/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import org.shoal.adapter.store.commands.AbstractSaveCommand;
import org.shoal.adapter.store.commands.LoadResponseCommand;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.adapter.store.commands.TouchCommand;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.store.DataStoreEntry;
import org.shoal.ha.cache.impl.store.DataStoreEntryUpdater;

public class SimpleDataStoreEntryUpdater<K, V>
extends DataStoreEntryUpdater<K, V> {
    @Override
    public SaveCommand<K, V> createSaveCommand(DataStoreEntry<K, V> entry, K k, V v) {
        SaveCommand<K, V> cmd = new SaveCommand<K, V>(k, v, entry.incrementAndGetVersion(), System.currentTimeMillis(), this.ctx.getDefaultMaxIdleTimeInMillis());
        super.updateMetaInfoInDataStoreEntry(entry, cmd);
        entry.setIsReplicaNode(false);
        return cmd;
    }

    @Override
    public LoadResponseCommand<K, V> createLoadResponseCommand(DataStoreEntry<K, V> entry, K k, long minVersion) {
        LoadResponseCommand cmd = null;
        if (entry != null && entry.isReplicaNode() && entry.getVersion() >= minVersion) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SimpleDataStoreEntryUpdater.createLoadResp  entry.version " + entry.getVersion() + ">= " + minVersion + "; rawV.length = " + entry.getRawV());
            }
            cmd = new LoadResponseCommand(k, entry.getVersion(), entry.getRawV());
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                String entryMsg = entry == null ? "NULL ENTRY" : entry.getVersion() + " < " + minVersion;
                _logger.log(Level.FINE, "SimpleDataStoreEntryUpdater.createLoadResp " + entryMsg + "; rawV.length = " + (entry == null ? " null " : "" + entry.getRawV()));
            }
            cmd = new LoadResponseCommand(k, Long.MIN_VALUE, null);
        }
        return cmd;
    }

    @Override
    public void executeSave(DataStoreEntry<K, V> entry, SaveCommand<K, V> cmd) {
        if (entry != null && entry.getVersion() < cmd.getVersion()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SimpleDataStoreEntryUpdater.executeSave. SAVING ... entry = " + entry + "; entry.version = " + entry.getVersion() + "; cmd.version = " + cmd.getVersion() + "; cmd.maxIdle = " + cmd.getMaxIdleTime());
            }
            entry.setIsReplicaNode(true);
            super.updateMetaInfoInDataStoreEntry(entry, cmd);
            entry.setRawV(cmd.getRawV());
            this.updateFromPendingUpdates(entry);
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SimpleDataStoreEntryUpdater.executeSave. IGNORING ... entry = " + entry + "; entry.version = " + entry.getVersion() + "; cmd.version = " + cmd.getVersion());
        }
    }

    @Override
    public void executeTouch(DataStoreEntry<K, V> entry, TouchCommand<K, V> touchCmd) throws DataStoreException {
        entry.addPendingUpdate(touchCmd);
        this.updateFromPendingUpdates(entry);
        entry.setIsReplicaNode(true);
    }

    private void updateFromPendingUpdates(DataStoreEntry<K, V> entry) {
        TreeSet<AbstractSaveCommand<K, V>> pendingUpdates = entry.getPendingUpdates();
        if (pendingUpdates != null) {
            Iterator<AbstractSaveCommand<K, V>> iter = entry.getPendingUpdates().iterator();
            while (iter.hasNext()) {
                AbstractSaveCommand<K, V> pendingCmd = iter.next();
                if (entry.getVersion() > pendingCmd.getVersion()) {
                    iter.remove();
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "**Ignoring Pending touch because " + entry.getVersion() + " > " + pendingCmd.getVersion());
                    continue;
                }
                if (entry.getVersion() + 1L == pendingCmd.getVersion()) {
                    iter.remove();
                    super.updateMetaInfoInDataStoreEntry(entry, pendingCmd);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "**Updated with Pending touch because, cmd.version = " + entry.getVersion() + " & pending.version = " + pendingCmd.getVersion());
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) break;
                _logger.log(Level.FINE, "**Added Touch as pending because, cmd.version = " + entry.getVersion() + " & pending.version = " + pendingCmd.getVersion());
                break;
            }
        }
    }

    @Override
    public V getV(DataStoreEntry<K, V> entry) throws DataStoreException {
        V v = entry.getV();
        if (entry != null && v == null && entry.getRawV() != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SimpleDataStoreEntryUpdater.getV(): Reading from raw data: " + entry.getRawV().length);
            }
            v = super.deserializeV(entry.getRawV());
        }
        return v;
    }

    @Override
    public byte[] getState(V v) throws DataStoreException {
        return this.captureState(v);
    }

    @Override
    public V extractVFrom(LoadResponseCommand<K, V> cmd) throws DataStoreException {
        byte[] rawV = cmd.getRawV();
        return rawV == null ? null : (V)super.deserializeV(rawV);
    }
}

