/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.admin.config.ApplicationName;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public final class ConfigBeansUtilities {
    private final Applications apps;
    private final Domain domain;

    @Inject
    public ConfigBeansUtilities(Applications paramApps, Domain paramDomain) {
        this.apps = paramApps;
        this.domain = paramDomain;
    }

    public static String getDefaultFormat() {
        return "%client.name% %auth-user-name% %datetime% %request% %status% %response.length%";
    }

    public static String getDefaultRotationPolicy() {
        return "time";
    }

    public static String getDefaultRotationEnabled() {
        return "true";
    }

    public static String getDefaultRotationIntervalInMinutes() {
        return "1440";
    }

    public static String getDefaultQueueSizeInBytes() {
        return "4096";
    }

    public static boolean toBoolean(String value) {
        if (value != null) {
            String v = value.trim();
            return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
        }
        return false;
    }

    public List<Application> getSystemApplicationsReferencedFrom(String sn) {
        if (this.domain == null || sn == null) {
            throw new IllegalArgumentException("Null argument");
        }
        List<Application> allApps = this.getAllDefinedSystemApplications();
        if (allApps.isEmpty()) {
            return allApps;
        }
        Server s = this.getServerNamed(sn);
        ArrayList<Application> referencedApps = new ArrayList<Application>();
        List appsReferenced = s.getApplicationRef();
        for (ApplicationRef ref : appsReferenced) {
            for (Application app : allApps) {
                if (!ref.getRef().equals(app.getName())) continue;
                referencedApps.add(app);
            }
        }
        return referencedApps;
    }

    public Application getSystemApplicationReferencedFrom(String sn, String appName) {
        List<Application> allApps = this.getSystemApplicationsReferencedFrom(sn);
        for (Application app : allApps) {
            if (!app.getName().equals(appName)) continue;
            return app;
        }
        return null;
    }

    public boolean isNamedSystemApplicationReferencedFrom(String appName, String serverName) {
        List<Application> referencedApps = this.getSystemApplicationsReferencedFrom(serverName);
        for (Application app : referencedApps) {
            if (!app.getName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    public List<Server> getServers() {
        if (this.domain == null || this.domain.getServers() == null) {
            throw new IllegalArgumentException("Either domain is null or no <servers> element");
        }
        return this.domain.getServers().getServer();
    }

    public Server getServerNamed(String name) {
        if (this.domain == null || this.domain.getServers() == null || name == null) {
            throw new IllegalArgumentException("Either domain is null or no <servers> element");
        }
        List<Server> servers = this.domain.getServers().getServer();
        for (Server s : servers) {
            if (!name.equals(s.getName().trim())) continue;
            return s;
        }
        return null;
    }

    public List<Application> getAllDefinedSystemApplications() {
        ArrayList<Application> allSysApps = new ArrayList<Application>();
        SystemApplications sa = this.domain.getSystemApplications();
        if (sa != null) {
            for (ApplicationName m : sa.getModules()) {
                if (!(m instanceof Application)) continue;
                allSysApps.add((Application)m);
            }
        }
        return allSysApps;
    }

    public List<ApplicationRef> getApplicationRefsInServer(String sn) {
        return this.getApplicationRefsInServer(sn, true);
    }

    public List<ApplicationRef> getApplicationRefsInServer(String sn, boolean excludeSystemApps) {
        Servers ss = this.domain.getServers();
        List<Server> list = ss.getServer();
        Server theServer = null;
        for (Server s : list) {
            if (!s.getName().equals(sn)) continue;
            theServer = s;
            break;
        }
        if (theServer != null) {
            List<ApplicationName> modulesToExclude = excludeSystemApps ? this.domain.getSystemApplications().getModules() : Collections.emptyList();
            ArrayList<ApplicationRef> result = new ArrayList<ApplicationRef>();
            for (ApplicationRef candidateRef : theServer.getApplicationRef()) {
                String appRefModuleName = candidateRef.getRef();
                boolean isSystem = false;
                for (ApplicationName sysModule : modulesToExclude) {
                    if (!sysModule.getName().equals(appRefModuleName)) continue;
                    isSystem = true;
                    break;
                }
                if (isSystem) continue;
                result.add(candidateRef);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public ApplicationRef getApplicationRefInServer(String sn, String name) {
        Servers ss = this.domain.getServers();
        List<Server> list = ss.getServer();
        Server theServer = null;
        for (Server s : list) {
            if (!s.getName().equals(sn)) continue;
            theServer = s;
            break;
        }
        ApplicationRef aref = null;
        if (theServer != null) {
            List arefs = theServer.getApplicationRef();
            for (ApplicationRef ar : arefs) {
                if (!ar.getRef().equals(name)) continue;
                aref = ar;
                break;
            }
        }
        return aref;
    }

    public ApplicationName getModule(String moduleID) {
        for (ApplicationName module : this.apps.getModules()) {
            if (!module.getName().equals(moduleID)) continue;
            return module;
        }
        return null;
    }

    public String getEnabled(String sn, String moduleID) {
        ApplicationRef appRef = this.getApplicationRefInServer(sn, moduleID);
        if (appRef != null) {
            return appRef.getEnabled();
        }
        return null;
    }

    public String getVirtualServers(String sn, String moduleID) {
        ApplicationRef appRef = this.getApplicationRefInServer(sn, moduleID);
        if (appRef != null) {
            return appRef.getVirtualServers();
        }
        return null;
    }

    public String getContextRoot(String moduleID) {
        ApplicationName module = this.getModule(moduleID);
        if (module == null) {
            return null;
        }
        if (module instanceof Application) {
            return ((Application)module).getContextRoot();
        }
        return null;
    }

    public String getLibraries(String moduleID) {
        ApplicationName module = this.getModule(moduleID);
        if (module == null) {
            return null;
        }
        if (module instanceof Application) {
            return ((Application)module).getLibraries();
        }
        return null;
    }

    public String getLocation(String moduleID) {
        ApplicationName module = this.getModule(moduleID);
        if (module == null) {
            return null;
        }
        String location = null;
        if (module instanceof Application) {
            location = ((Application)module).getLocation();
        }
        try {
            if (location != null) {
                return new URI(location).getPath();
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getDirectoryDeployed(String moduleID) {
        ApplicationName module = this.getModule(moduleID);
        if (module == null) {
            return null;
        }
        if (module instanceof Application) {
            return ((Application)module).getDirectoryDeployed();
        }
        return null;
    }

    public static String join(Iterable<String> list, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public Domain getDomain() {
        return this.domain;
    }
}

