/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class TreatExpression
extends AbstractEncapsulatedExpression {
    private String asIdentifier;
    private AbstractExpression collectionValuedPathExpression;
    private AbstractExpression entityType;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterCollectionValuedPathExpression;
    private int parameterIndex;

    public TreatExpression(AbstractExpression parent) {
        super(parent, "TREAT");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getCollectionValuedPathExpression().accept(visitor);
        this.getEntityType().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getCollectionValuedPathExpression());
        children.add(this.getEntityType());
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.collectionValuedPathExpression != null) {
            children.add(this.collectionValuedPathExpression);
        }
        if (this.hasSpaceAfterCollectionValuedPathExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.asIdentifier != null) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.entityType != null) {
            children.add(this.entityType);
        }
    }

    @Override
    public final JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.collectionValuedPathExpression != null && this.collectionValuedPathExpression.isAncestor(expression)) {
            return this.getQueryBNF("collection_valued_path_expression");
        }
        if (this.entityType != null && this.entityType.isAncestor(expression)) {
            return this.getQueryBNF("entity_type_literal");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    public Expression getCollectionValuedPathExpression() {
        if (this.collectionValuedPathExpression == null) {
            this.collectionValuedPathExpression = this.buildNullExpression();
        }
        return this.collectionValuedPathExpression;
    }

    public Expression getEntityType() {
        if (this.entityType == null) {
            this.entityType = this.buildNullExpression();
        }
        return this.entityType;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("treat_expression");
    }

    public boolean hasAs() {
        return this.asIdentifier != null;
    }

    public boolean hasCollectionValuedPathExpression() {
        return this.collectionValuedPathExpression != null && !this.collectionValuedPathExpression.isNull();
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasCollectionValuedPathExpression() || this.hasAs() || this.hasEntityType();
    }

    public boolean hasEntityType() {
        return this.entityType != null && !this.entityType.isNull();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterCollectionValuedPathExpression() {
        return this.hasSpaceAfterCollectionValuedPathExpression;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        if (!(this.parameterIndex != 0 || character != '+' && character != '-' || this.hasLeftParenthesis())) {
            this.parameterIndex = -1;
            return true;
        }
        return super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        this.parameterIndex = 0;
        this.collectionValuedPathExpression = this.parse(wordParser, "collection_valued_path_expression", tolerant);
        if (this.parameterIndex == -1) {
            return;
        }
        boolean bl = this.hasSpaceAfterCollectionValuedPathExpression = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("AS")) {
            this.asIdentifier = wordParser.moveForward("AS");
            this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parameterIndex = 1;
        if (tolerant) {
            this.entityType = this.parse(wordParser, "entity_type_literal", tolerant);
        } else {
            this.entityType = new EntityTypeLiteral(this, wordParser.word());
            this.entityType.parse(wordParser, tolerant);
        }
    }

    @Override
    protected void removeEncapsulatedExpression() {
        this.entityType = null;
        this.asIdentifier = null;
        this.hasSpaceAfterAs = false;
        this.collectionValuedPathExpression = null;
        this.hasSpaceAfterCollectionValuedPathExpression = false;
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.collectionValuedPathExpression != null) {
            writer.append(this.collectionValuedPathExpression);
        }
        if (this.hasSpaceAfterCollectionValuedPathExpression) {
            writer.append(' ');
        }
        if (this.asIdentifier != null) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.entityType != null) {
            writer.append(this.entityType);
        }
    }
}

