/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDUnsignedByteEncoder
extends SimpleTypeEncoderBase {
    private static final short upperBound = 255;
    private static final SimpleTypeEncoder encoder = new XSDUnsignedByteEncoder();

    private XSDUnsignedByteEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        return ((Short)obj).toString();
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        try {
            Short value = Short.valueOf(str);
            if (value < 0 || value > 255) {
                throw new DeserializationException("xsd.invalid.unsignedByte", str);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new DeserializationException("xsd.invalid.unsignedByte", str);
        }
    }

    @Override
    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }
}

