/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.web.WebModuleDecorator;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgiweb.ContextPathCollisionDetector;
import org.glassfish.osgiweb.OSGiWebDeployer;
import org.glassfish.osgiweb.OSGiWebModuleDecorator;
import org.glassfish.osgiweb.WebBundleURLStreamHandlerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class WebExtender
implements Extender {
    private static final Logger logger = Logger.getLogger(WebExtender.class.getPackage().getName());
    private BundleContext context;
    private ServiceRegistration urlHandlerService;
    private OSGiWebModuleDecorator wmd;
    private OSGiWebDeployer deployer;
    private ServiceRegistration wmdReg;

    public WebExtender(BundleContext context) {
        this.context = context;
    }

    public synchronized void start() {
        ContextPathCollisionDetector.get();
        this.registerWmd();
        this.registerDeployer();
        this.addURLHandler();
    }

    public synchronized void stop() {
        ContextPathCollisionDetector.get().stop();
        this.removeURLHandler();
        this.unregisterDeployer();
        this.unregisterWmd();
    }

    private void registerDeployer() {
        this.deployer = new OSGiWebDeployer(this.context);
        this.deployer.register();
    }

    private void unregisterDeployer() {
        if (this.deployer != null) {
            this.deployer.unregister();
            this.deployer = null;
        }
    }

    private void addURLHandler() {
        Properties p = new Properties();
        p.put("url.handler.protocol", new String[]{"webbundle"});
        this.urlHandlerService = this.context.registerService(URLStreamHandlerService.class.getName(), (Object)new WebBundleURLStreamHandlerService(), (Dictionary)p);
    }

    private void removeURLHandler() {
        if (this.urlHandlerService != null) {
            this.urlHandlerService.unregister();
        }
    }

    private void registerWmd() {
        this.wmd = new OSGiWebModuleDecorator();
        this.wmdReg = this.context.registerService(WebModuleDecorator.class.getName(), (Object)this.wmd, null);
    }

    private void unregisterWmd() {
        if (this.wmdReg == null) {
            return;
        }
        this.wmdReg.unregister();
        this.wmd.deActivate();
    }
}

