/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumberType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MathType
extends ClassType
implements NumberType {
    public MathType(String name, Class clazz, int enumType, TypeTable typetab) {
        super(name, clazz, enumType, typetab);
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Number getValue(Number value) {
        Number ret = null;
        if (value == null) {
            ret = null;
        } else if ("java.math.BigDecimal".equals(this.getName())) {
            if (value instanceof BigDecimal) {
                ret = value;
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Double) {
                ret = new BigDecimal(((Double)value).toString());
            } else if (value instanceof Float) {
                ret = new BigDecimal(((Float)value).toString());
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(value.longValue());
            }
        } else if ("java.math.BigInteger".equals(this.getName())) {
            if (value instanceof BigInteger) {
                ret = value;
            } else if (value instanceof Double) {
                ret = new BigDecimal(((Double)value).toString()).toBigInteger();
            } else if (value instanceof Float) {
                ret = new BigDecimal(((Float)value).toString()).toBigInteger();
            } else if (value instanceof Number) {
                ret = BigInteger.valueOf(value.longValue());
            }
        }
        return ret;
    }

    @Override
    public Number negate(Number value) {
        Number ret = null;
        if (value == null) {
            ret = null;
        } else if ("java.math.BigDecimal".equals(this.getName())) {
            if (value instanceof BigDecimal) {
                ret = ((BigDecimal)value).negate();
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal(((BigInteger)value).negate());
            } else if (value instanceof Double) {
                ret = new BigDecimal(((Double)value).toString()).negate();
            } else if (value instanceof Float) {
                ret = new BigDecimal(((Float)value).toString()).negate();
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(-value.longValue());
            }
        } else if ("java.math.BigInteger".equals(this.getName())) {
            if (value instanceof BigInteger) {
                ret = ((BigInteger)value).negate();
            } else if (value instanceof Double) {
                ret = new BigDecimal(((Double)value).toString()).negate().toBigInteger();
            } else if (value instanceof Float) {
                ret = new BigDecimal(((Float)value).toString()).negate().toBigInteger();
            } else if (value instanceof Number) {
                ret = BigInteger.valueOf(-value.longValue());
            }
        }
        return ret;
    }
}

