/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class JavaEEExtender
implements Extender {
    private static final String DEPLOYMENT_TIMEOUT = "org.glassfish.osgijavaeebase.deployment.timeout";
    private volatile OSGiContainer c;
    private static final Logger logger = Logger.getLogger(JavaEEExtender.class.getPackage().getName());
    private BundleContext context;
    private ServiceRegistration reg;
    private BundleTracker tracker;
    private ExecutorService executorService;

    public JavaEEExtender(BundleContext context) {
        this.context = context;
    }

    @Override
    public synchronized void start() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.c = new OSGiContainer(this.context);
        this.c.init();
        this.reg = this.context.registerService(OSGiContainer.class.getName(), (Object)this.c, null);
        this.tracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)new HybridBundleTrackerCustomizer());
        this.tracker.open();
    }

    @Override
    public synchronized void stop() {
        if (this.c == null) {
            return;
        }
        OSGiContainer tmp = this.c;
        this.c = null;
        tmp.shutdown();
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.tracker = null;
        this.reg.unregister();
        this.reg = null;
        this.executorService.shutdownNow();
    }

    private synchronized OSGiApplicationInfo deploy(Bundle b) {
        if (!this.isStarted()) {
            return null;
        }
        try {
            return this.c.deploy(b);
        }
        catch (Throwable e) {
            logger.logp(Level.SEVERE, "JavaEEExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "JavaEEExtender", "deploy", "Exception Stack Trace", e);
            return null;
        }
    }

    private synchronized void undeploy(Bundle b) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (this.c.isDeployed(b)) {
                this.c.undeploy(b);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "JavaEEExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "JavaEEExtender", "undeploy", "Exception Stack Trace", e);
        }
    }

    private boolean isStarted() {
        return this.c != null;
    }

    private class HybridBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private Map<Long, Future<OSGiApplicationInfo>> deploymentTasks = new ConcurrentHashMap<Long, Future<OSGiApplicationInfo>>();

        private HybridBundleTrackerCustomizer() {
        }

        public Object addingBundle(final Bundle bundle, BundleEvent event) {
            if (!JavaEEExtender.this.isStarted()) {
                return null;
            }
            int state = bundle.getState();
            if (this.isReady(event, state)) {
                Future<OSGiApplicationInfo> future = JavaEEExtender.this.executorService.submit(new Callable<OSGiApplicationInfo>(){

                    @Override
                    public OSGiApplicationInfo call() throws Exception {
                        return JavaEEExtender.this.deploy(bundle);
                    }
                });
                this.deploymentTasks.put(bundle.getBundleId(), future);
                return bundle;
            }
            return null;
        }

        private boolean isReady(BundleEvent event, int state) {
            return state == 32 || state == 8 && event != null && event.getType() == 512;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            if (!JavaEEExtender.this.isStarted()) {
                return;
            }
            Future<OSGiApplicationInfo> deploymentTask = this.deploymentTasks.remove(bundle.getBundleId());
            if (deploymentTask == null) {
                assert (false);
                return;
            }
            try {
                OSGiApplicationInfo deployedApp = null;
                try {
                    deployedApp = deploymentTask.get(this.getDeploymentTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    logger.logp(Level.FINE, "JavaEEExtender$HybridBundleTrackerCustomizer", "removedBundle", "Undeployer times out waiting for deployment to finish for bundle " + bundle, e);
                    boolean isCancelled = deploymentTask.cancel(true);
                    if (!isCancelled) {
                        deployedApp = deploymentTask.get();
                    }
                    logger.logp(Level.INFO, "JavaEEExtender$HybridBundleTrackerCustomizer", "removedBundle", "isCancelled = {0}", new Object[]{isCancelled});
                }
                if (deployedApp != null || JavaEEExtender.this.c.isDeployed(bundle)) {
                    JavaEEExtender.this.undeploy(bundle);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                logger.logp(Level.FINE, "JavaEEExtender$HybridBundleTrackerCustomizer", "removedBundle", "e = {0}", new Object[]{e});
            }
        }

        public long getDeploymentTimeout() {
            String time = JavaEEExtender.this.context.getProperty(JavaEEExtender.DEPLOYMENT_TIMEOUT);
            long timeOut = time != null ? Long.valueOf(time) : 10000L;
            return timeOut;
        }
    }
}

