/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.impl.ExecutionTransitioner;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.navigator.NavigatorFactory;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.jsl.model.Flow;
import java.util.List;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class FlowControllerImpl
implements IExecutionElementController {
    private static final String CLASSNAME = FlowControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private final RuntimeJobExecution jobExecution;
    private final JobContextImpl jobContext;
    protected ModelNavigator<Flow> flowNavigator;
    protected Flow flow;
    private long rootJobExecutionId;
    private ExecutionTransitioner transitioner;
    private volatile IController currentStoppableElementController = null;
    private static IPersistenceManagerService _persistenceManagementService = ServicesManagerImpl.getInstance().getPersistenceManagerService();

    public FlowControllerImpl(RuntimeJobExecution jobExecution, Flow flow, long rootJobExecutionId) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.flowNavigator = NavigatorFactory.createFlowNavigator(flow);
        this.flow = flow;
        this.rootJobExecutionId = rootJobExecutionId;
    }

    @Override
    public ExecutionStatus execute() {
        if (!this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            this.transitioner = new ExecutionTransitioner(this.jobExecution, this.rootJobExecutionId, this.flowNavigator);
            return this.transitioner.doExecutionLoop();
        }
        return new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
    }

    @Override
    public void stop() {
        IController stoppableElementController = this.transitioner.getCurrentStoppableElementController();
        if (stoppableElementController != null) {
            stoppableElementController.stop();
        }
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        return this.transitioner.getStepExecIds();
    }
}

