/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TestServlet
extends GenericTCKServlet {
    private static final String EXPECTED_MIME_TYPE = "application/x-java-class";
    private static final String MIME_OBJECT = "/WEB-INF/classes/tests/javax_servlet/ServletContext/GetMimeTypeTestServlet.class";

    public void getMajorVersion(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        if (context.getMajorVersion() == 4) {
            passed = true;
        } else {
            passed = false;
            pw.println("getMajorVersion() returned " + context.getMajorVersion());
            pw.println("Expected ServletContext.getMajorVersion() -> 4 ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getMinorVersion(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        int expectedResult = 0;
        int result = context.getMinorVersion();
        if (result == expectedResult) {
            passed = true;
        } else {
            passed = false;
            pw.println("getMinorVersion() returned incorrect result");
            pw.println("Expected result = " + expectedResult + " ");
            pw.println("Actual result = " + result + " ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getMimeType(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String result = context.getMimeType(MIME_OBJECT);
        if (result != null) {
            if (result.equals(EXPECTED_MIME_TYPE)) {
                passed = true;
            } else {
                passed = false;
                pw.println("getMimeType(/WEB-INF/classes/tests/javax_servlet/ServletContext/GetMimeTypeTestServlet.class) returned incorrect result\n\tExpected result = application/x-java-class\n\tActual result = " + result);
            }
        } else {
            passed = false;
            pw.println("getMimeType( /WEB-INF/classes/tests/javax_servlet/ServletContext/GetMimeTypeTestServlet.class ) returned a null result\n\tExpected result = application/x-java-class");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getMimeType_1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String param;
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String mimeType = context.getMimeType(param = "/META-INF/MANIFEST.MF");
        if (mimeType == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getMimeType(" + param + ") did not return null");
            pw.println("Actual result = " + mimeType + " ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getRealPath(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String path = "/servlet_js_ServletContext/Test";
        String win32Path = new StringBuffer(45).append(File.separatorChar).append("servlet_js_ServletContext").append(File.separatorChar).append("Test").toString();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String realPath = context.getRealPath(path);
        if (realPath == null || realPath.indexOf(path) > -1 || realPath.indexOf(win32Path) > -1) {
            passed = true;
            pw.println("realPath = " + realPath);
        } else {
            passed = false;
            pw.println("getRealPath(" + path + ") did not contain the named files");
            pw.println("Actual result = " + realPath + " ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getResourcePaths(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        Iterator resources = null;
        String tmp = null;
        String path = "/WEB-INF/";
        Set realPath = context.getResourcePaths(path);
        pw.println("GetResourcePathsTest: Start test for path=" + path);
        if (realPath != null) {
            if (!realPath.isEmpty()) {
                resources = realPath.iterator();
                tmp = (String)resources.next();
                pw.println("GetResourcePathsTest: " + tmp);
                while (resources.hasNext()) {
                    pw.println("GetResourcePathsTest: " + resources.next());
                }
            } else {
                passed = false;
            }
        } else {
            passed = false;
            pw.println("GetResourcePathsTest: returned null resourcepath");
        }
        path = "/WEB-INF/classes/com/sun/ts/tests/servlet/api/javax_servlet/servletcontext/";
        realPath = context.getResourcePaths(path);
        pw.println("GetResourcePathsTest: Start test for path=" + path);
        if (realPath != null) {
            if (!realPath.isEmpty()) {
                resources = realPath.iterator();
                tmp = (String)resources.next();
                pw.println("GetResourcePathsTest: " + tmp);
                while (resources.hasNext()) {
                    pw.println("GetResourcePathsTest: " + resources.next());
                }
            } else {
                passed = false;
                pw.println("Error: missing contents");
            }
        } else {
            passed = false;
            pw.println("Error: null resourcepath");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getResourceAsStream(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path;
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        InputStream in = context.getResourceAsStream(path = "/WEB-INF/web.xml");
        if (in != null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getResourceAsStream(" + path + ") returned a null");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getResourceAsStream_1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path;
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        InputStream in = context.getResourceAsStream(path = "/dummy");
        if (in == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getResourceAsStream(" + path + ") returned a non-null ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getResource(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path;
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        URL resourceURL = context.getResource(path = "/WEB-INF/web.xml");
        if (resourceURL != null) {
            String result = resourceURL.toString();
            if (result.indexOf(path) > -1) {
                passed = true;
            } else {
                passed = false;
                pw.println("Could not locate " + path + " in the returned URL");
                pw.println("Actual result = " + result + " ");
            }
        } else {
            passed = false;
            pw.println("getResource(" + path + ") returned a null");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getResource_1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path;
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        URL resourceURL = context.getResource(path = "/doesnotexist");
        if (resourceURL == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("ServletContext.getResource(" + path + ") did not return correct result");
            pw.println("Expected result = null");
            pw.println("Actual result = |" + resourceURL + "|");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getResource_2(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        try {
            URL resourceURL = context.getResource("invalid/contextPath");
            passed = false;
            pw.println("Test FAILED.  Expected a MalformedURLException to be thrown when ServletContext.getResource(String)  is provided a value that does not start with a '/'");
        }
        catch (MalformedURLException ex) {
            passed = true;
            pw.println("GetResource_2Test Test PASSED");
            pw.println("Expected java.net.MalformedURLException to be thrown");
        }
        catch (Throwable t) {
            passed = false;
            pw.println("GetResource_2Test Test FAILED");
            pw.println("Unexpected Exception is thrown: " + t.toString());
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetAttribute(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String param = "ManKind";
        String param2 = "humane";
        context.setAttribute(param, (Object)param2);
        Object attr = context.getAttribute(param);
        if (attr != null) {
            if (attr.getClass().getName().equals("java.lang.String")) {
                String sAttr = (String)attr;
                if (sAttr.equals(param2)) {
                    passed = true;
                } else {
                    passed = false;
                    pw.println("getAttribute(" + param + ") returned incorrect results");
                    pw.println("Expected result = " + param2 + " ");
                    pw.println("Actual result = |" + sAttr + "| ");
                }
            } else {
                passed = false;
                pw.println("getAttribute(" + param + ") did not return an attribute of type String");
            }
        } else {
            passed = false;
            pw.println("getAttribute(" + param + ") returned a null result ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetAttribute_1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        Object attr = context.getAttribute("Womankind");
        if (attr == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getAttribute(String) did not return null");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetContext(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String alternateServlet = request.getServletContext().getContextPath() + "/GetNamedDispatcherTest";
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        ServletContext context2 = context.getContext(alternateServlet);
        if (context2 == context || context2 == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getContext(String) returned incorrect result");
            pw.println("Expected getServletContext(String) to return the same context for another servlet ");
            pw.println(" in the same context as the current test servlet, or to return a null value.");
            pw.println("Context returned from getServletConfig().getServletContext(): " + context);
            pw.println("Context returned from context.getContext(String): " + context2);
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetInitParameterNames(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String expectedResult1 = "EDITOR";
        boolean expectedResult1Found = false;
        String expectedResult2 = "OS";
        boolean expectedResult2Found = false;
        Enumeration initP = context.getInitParameterNames();
        if (initP.hasMoreElements()) {
            while (initP.hasMoreElements()) {
                String name = (String)initP.nextElement();
                pw.println("Initialization parameter: " + name);
                if (name.equals(expectedResult1)) {
                    if (!expectedResult1Found) {
                        expectedResult1Found = true;
                        continue;
                    }
                    passed = false;
                    pw.println("getInitParameterNames() method return an attribute name twice ");
                    pw.println("The attribute already specified was " + expectedResult1 + " ");
                    continue;
                }
                if (!name.equals(expectedResult2)) continue;
                if (!expectedResult2Found) {
                    expectedResult2Found = true;
                    continue;
                }
                passed = false;
                pw.println("getInitParameterNames() method return an attribute name twice ");
                pw.println("The attribute already specified was " + expectedResult2 + " ");
            }
            if (!expectedResult1Found && expectedResult2Found) {
                passed = false;
                pw.println("getInitParameterNames() method did not return all the init parameters");
            }
        } else {
            passed = false;
            pw.println("getInitParameterNames() returned and empty enumeration");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetInitParameter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String param = "EDITOR";
        String expectedResult = "VI";
        String result = context.getInitParameter(param);
        if (result != null) {
            if (result.equals("VI")) {
                passed = true;
            } else {
                passed = false;
                pw.println("getInitParameter(String) gave incorrect results");
                pw.println("Expected result = " + expectedResult + " ");
                pw.println("Actual result = |" + result + "| ");
            }
        } else {
            passed = false;
            pw.println("getInitParameter(" + param + ") returned a null");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetInitParameterNull(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletContext context = this.getServletContext();
        String initParam = context.getInitParameter("nothing_is_set_here_negative_compatibility_test");
        if (initParam == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getInitParameter(String)  returned incorrect result");
            pw.println("Expected result = null ");
            pw.println("Actual result =|" + initParam + "| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextRemoveAttribute(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String param = "Mankind";
        context.setAttribute(param, (Object)"humane");
        context.removeAttribute(param);
        Object result = null;
        result = context.getAttribute(param);
        if (result == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("removeAttribute(" + param + ") returned incorrect result ");
            pw.println("Expected result = null ");
            pw.println("Actual result = |" + result + "| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextSetAttribute(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String param1 = "Mankind";
        String param2 = "humane";
        context.setAttribute(param1, (Object)param2);
        Object attr = context.getAttribute(param1);
        if (attr != null) {
            if (attr.getClass().getName().equals("java.lang.String")) {
                String sAttr = (String)attr;
                if (sAttr.equals(param2)) {
                    passed = true;
                } else {
                    passed = false;
                    pw.println("setAttribute(" + param1 + "," + param2 + ") did not set the attribute properly");
                    pw.println("Expected result = " + param2 + " ");
                    pw.println("Actual result = |" + sAttr + "| ");
                }
            } else {
                passed = false;
                pw.println("setAttribute(" + param1 + "," + param2 + ") did not set an attribute of type String properly");
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextSetAttribute_1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String param1 = "Mankind";
        String param2 = "humane";
        String param3 = "being";
        context.setAttribute(param1, (Object)param2);
        context.setAttribute(param1, (Object)param3);
        Object attr = context.getAttribute(param1);
        if (attr != null) {
            if (attr.getClass().getName().equals("java.lang.String")) {
                String sAttr = (String)attr;
                if (sAttr.equals(param3)) {
                    passed = true;
                } else if (sAttr.equals(param2)) {
                    passed = false;
                    pw.println("Failed to override set value");
                } else {
                    passed = false;
                    pw.println("Expected result = " + param3 + " ");
                    pw.println("Actual result = |" + sAttr + "| ");
                }
            } else {
                passed = false;
                pw.println("setAttribute(" + param1 + "," + param2 + ") didnot set an attribute of type String properly");
            }
        } else {
            passed = false;
            pw.println("setAttribute(String, Object) didnot set attribute");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextSetAttribute_2(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String param = "Mankind";
        context.setAttribute(param, null);
        Object result = null;
        result = context.getAttribute(param);
        if (result == null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getAttribute(" + param + ") returned incorrect result ");
            pw.println("Expected result = null ");
            pw.println("Actual result = |" + result + "| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetAttributeNames(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        context.setAttribute("Chef", (Object)"expert");
        context.setAttribute("chief", (Object)"commanding");
        int count = 0;
        String expectedResult1 = "Chef";
        boolean expectedResult1Found = false;
        String expectedResult2 = "chief";
        boolean expectedResult2Found = false;
        int expectedCount = 2;
        Enumeration attrs = context.getAttributeNames();
        if (attrs.hasMoreElements()) {
            Vector<String> v = new Vector<String>();
            while (attrs.hasMoreElements()) {
                String name = (String)attrs.nextElement();
                if (name.equals(expectedResult1)) {
                    if (!expectedResult1Found) {
                        ++count;
                        expectedResult1Found = true;
                        continue;
                    }
                    passed = false;
                    pw.println("getAttributeNames() method return an attribute name twice ");
                    pw.println("    The attribute already specified was " + expectedResult1 + " ");
                    continue;
                }
                if (name.equals(expectedResult2)) {
                    if (!expectedResult2Found) {
                        ++count;
                        expectedResult2Found = true;
                        continue;
                    }
                    passed = false;
                    pw.println("getAttributeNames() method return an attribute name twice ");
                    pw.println("    The attribute already specified was " + expectedResult2 + " ");
                    continue;
                }
                v.add(name);
            }
            if (count != expectedCount) {
                passed = false;
                pw.println("getAttributeNames() method did not return the correct number of init parameters");
                pw.println("Expected count = " + expectedCount);
                pw.println("Actual count = " + count);
                pw.println("The expected attribute names received were :");
                if (expectedResult1Found) {
                    pw.println(expectedResult1);
                }
                if (expectedResult2Found) {
                    pw.println(expectedResult2);
                }
                pw.println("    Other attribute names received were :");
                for (int i = 0; i <= v.size() - 1; ++i) {
                    pw.println("" + v.elementAt(i).toString());
                }
            } else {
                passed = true;
            }
        } else {
            passed = false;
            pw.println("getAttributeNames() returned an empty enumeration");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletContextGetRequestDispatcher(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String path = "/WEB-INF/web.xml";
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        RequestDispatcher rd = context.getRequestDispatcher(path);
        if (rd != null) {
            passed = true;
        } else {
            passed = false;
            pw.println("getRequestDispatcher(" + path + ") returned incorrect result ");
            pw.println("Expected result != null ");
            pw.println("Actual result = |null| ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getNamedDispatcher(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/GetNamedDispatcherTest";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        rd.forward(request, response);
    }

    public void getNamedDispatcher_1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String path = "/DoesNotExistGetNamedDispatcherTest";
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        RequestDispatcher tmp = context.getNamedDispatcher(path);
        if (tmp != null) {
            passed = false;
            pw.println("non-null return");
        } else {
            passed = true;
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServerInfo(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String info = context.getServerInfo();
        if (info != null) {
            passed = true;
            pw.println("ServerInfo = " + info);
        } else {
            passed = false;
            pw.println("getServerInfo() returned a null ");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServletNameTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String name = context.getServletContextName();
        if (name.equals("SerJaxSerServletContext")) {
            passed = true;
            pw.println("ame = " + name);
        } else {
            passed = false;
            pw.println("getServletContextName() returned " + name);
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServletTempDir(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        try {
            File tmp = (File)context.getAttribute("javax.servlet.context.tempdir");
            if (tmp != null) {
                pw.println("javax.servlet.context.tempdir=" + tmp.getAbsolutePath());
                if (tmp.exists()) {
                    passed = true;
                } else {
                    passed = false;
                    pw.println("javax.servlet.context.tempdir points to a non-existing dir");
                }
            } else {
                passed = false;
                pw.println("javax.servlet.temp.dir attribute value is null");
            }
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception when retrieving javax.servlet.temp.dir attribute:" + ex.toString());
        }
        ServletTestUtil.printResult(pw, passed);
    }
}

