/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.AbstractSessionContextImpl;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import java.util.logging.Level;
import javax.ejb.TimerService;
import javax.naming.InitialContext;

public final class SingletonContextImpl
extends AbstractSessionContextImpl {
    SingletonContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        try {
            this.initialContext = new InitialContext();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception in creating InitialContext", ex);
        }
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EJBTimerService timerService = EJBTimerService.getValidEJBTimerService();
        return new EJBTimerServiceWrapper(timerService, this);
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Singleton setRollbackOnly not allowed");
        }
        if (this.container.isBeanManagedTran) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        this.doGetSetRollbackTxAttrCheck();
        JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
        try {
            if (tm.getStatus() == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            tm.setRollbackOnly();
        }
        catch (Exception ex) {
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Singleton getRollbackOnly not allowed");
        }
        if (this.container.isBeanManagedTran) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        this.doGetSetRollbackTxAttrCheck();
        JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
        try {
            int status = tm.getStatus();
            if (status == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            return status == 1 || status == 4 || status == 9;
        }
        catch (Exception ex) {
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    @Override
    public synchronized Object lookup(String name) {
        Object o = null;
        if (name == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.initialContext == null) {
            throw new IllegalArgumentException("InitialContext is null");
        }
        try {
            String lookupString = name.startsWith("java:") ? name : "java:comp/env/" + name;
            o = this.initialContext.lookup(lookupString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return o;
    }
}

