/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.remote.ServerRemoteRestAdminCommand;
import com.sun.enterprise.admin.util.InstanceCommandExecutor;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.net.ConnectException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.ServiceLocator;

public class InstanceRestCommandExecutor
extends ServerRemoteRestAdminCommand
implements Runnable,
InstanceCommand {
    private Server server;
    private ParameterMap params;
    private ActionReport aReport;
    private String commandName;
    private FailurePolicy offlinePolicy;
    private FailurePolicy failPolicy;
    private InstanceCommandResult result;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(InstanceCommandExecutor.class);

    public InstanceRestCommandExecutor(ServiceLocator habitat, String name, FailurePolicy fail, FailurePolicy offline, Server server, String host, int port, Logger logger, ParameterMap p, ActionReport r, InstanceCommandResult res) throws CommandException {
        super(habitat, name, host, port, false, "admin", "", logger);
        this.server = server;
        this.params = p;
        this.aReport = r;
        this.commandName = name;
        this.offlinePolicy = offline;
        this.failPolicy = fail;
        this.result = res;
    }

    public String getCommandOutput() {
        return this.output;
    }

    public Server getServer() {
        return this.server;
    }

    public ActionReport getReport() {
        return this.aReport;
    }

    private void copyActionReportContent(ActionReport source, ActionReport dest) {
        if (source == null || dest == null) {
            return;
        }
        dest.setActionExitCode(source.getActionExitCode());
        dest.setExtraProperties(source.getExtraProperties());
        this.copyMessagePart(source.getTopMessagePart(), dest.getTopMessagePart());
        List subReports = source.getSubActionsReport();
        if (subReports != null) {
            for (ActionReport subrep : subReports) {
                this.copyActionReportContent(subrep, dest.addSubActionsReport());
            }
        }
    }

    private void copyMessagePart(ActionReport.MessagePart source, ActionReport.MessagePart dest) {
        if (source == null || dest == null) {
            return;
        }
        dest.setMessage(source.getMessage());
        dest.setChildrenType(source.getChildrenType());
        Properties props = source.getProps();
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                dest.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (ActionReport.MessagePart chmp : source.getChildren()) {
            this.copyMessagePart(chmp, dest.addChild());
        }
    }

    @Override
    public void run() {
        try {
            this.executeCommand(this.params);
            this.copyActionReportContent(super.getActionReport(), this.aReport);
            if (StringUtils.ok((String)this.getCommandOutput())) {
                this.aReport.setMessage(strings.getLocalString("ice.successmessage", "{0}:\n{1}\n", new Object[]{this.getServer().getName(), this.getCommandOutput()}));
            }
        }
        catch (CommandException cmdEx) {
            ActionReport.ExitCode finalResult;
            if (cmdEx.getCause() instanceof ConnectException) {
                finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)this.offlinePolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                if (!finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.warnoffline", "WARNING: Instance {0} seems to be offline; command {1} was not replicated to that instance", new Object[]{this.getServer().getName(), this.commandName}));
                } else {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.failoffline", "FAILURE: Instance {0} seems to be offline; command {1} was not replicated to that instance", new Object[]{this.getServer().getName(), this.commandName}));
                }
            } else {
                finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)this.failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.commandFailed", "FAILURE: Command {0} failed on server instance {1}: {2}", new Object[]{this.commandName, this.getServer().getName(), cmdEx.getMessage()}));
                } else {
                    this.aReport.setMessage(strings.getLocalString("clusterutil.commandWarning", "WARNING: Command {0} did not complete successfully on server instance {1}: {2}", new Object[]{this.commandName, this.getServer().getName(), cmdEx.getMessage()}));
                }
            }
            this.aReport.setActionExitCode(finalResult);
        }
        this.result.setInstanceCommand((InstanceCommand)this);
    }
}

