/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import javax.xml.namespace.QName;

public class XSDQNameEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDQNameEncoder();

    private XSDQNameEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        QName qn = (QName)obj;
        String str = "";
        String nsURI = qn.getNamespaceURI();
        if (nsURI != null && nsURI.length() > 0) {
            String prefix = writer.getPrefix(nsURI);
            if (prefix == null) {
                prefix = writer.getPrefixFactory().getPrefix(nsURI);
            }
            str = str + prefix + ":";
        }
        str = str + qn.getLocalPart();
        return str;
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        String uri = "";
        String prefix = XmlUtil.getPrefix(str = EncoderUtils.collapseWhitespace(str));
        if (prefix != null && (uri = reader.getURI(prefix)) == null) {
            throw new DeserializationException("xsd.unknownPrefix", prefix);
        }
        String localPart = XmlUtil.getLocalPart(str);
        return new QName(uri, localPart);
    }

    @Override
    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }

    @Override
    public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
        String uri;
        QName value = (QName)obj;
        if (value != null && !(uri = value.getNamespaceURI()).equals("") && writer.getPrefix(uri) == null) {
            writer.writeNamespaceDeclaration(uri);
        }
    }
}

