/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfig;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@CommandLock(value=CommandLock.LockType.NONE)
@Service(name="set-log-file-format")
@PerLookup
@I18n(value="set.log.file.format")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-log-file-format", description="set-log-file-format")})
public class SetLogFileFormat
implements AdminCommand {
    private static final String ODL_FORMATTER_NAME = "ODL";
    private static final String ULF_FORMATTER_NAME = "ULF";
    @Param(optional=true)
    @I18n(value="set.log.file.format.target")
    String target = "server";
    @Param(optional=true, defaultValue="ODL", primary=true)
    @I18n(value="set.log.file.format.formatter")
    String formatter = "ODL";
    @Inject
    LoggingConfig loggingConfig;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;
    @Inject
    ServerEnvironment env;
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(SetLogFileFormat.class);

    public void execute(AdminCommandContext context) {
        String formatterClassName = null;
        formatterClassName = this.formatter.equalsIgnoreCase(ODL_FORMATTER_NAME) ? ODLLogFormatter.class.getName() : (this.formatter.equalsIgnoreCase(ULF_FORMATTER_NAME) ? UniformLogFormatter.class.getName() : this.formatter);
        if (formatterClassName == null || this.formatter.isEmpty()) {
            formatterClassName = ODLLogFormatter.class.getName();
        }
        HashMap<String, String> loggingProperties = new HashMap<String, String>();
        loggingProperties.put("com.sun.enterprise.server.logging.GFFileHandler.formatter", formatterClassName);
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        boolean isConfig = false;
        String targetConfigName = "";
        try {
            Config config = this.domain.getConfigNamed(this.target);
            if (config != null) {
                targetConfigName = this.target;
                isConfig = true;
            } else {
                Server targetServer = this.domain.getServerNamed(this.target);
                if (targetServer != null) {
                    if (targetServer.isDas()) {
                        isDas = true;
                    } else {
                        isInstance = true;
                        Cluster clusterForInstance = targetServer.getCluster();
                        targetConfigName = clusterForInstance != null ? clusterForInstance.getConfigRef() : targetServer.getConfigRef();
                    }
                } else {
                    Cluster cluster = this.domain.getClusterNamed(this.target);
                    if (cluster != null) {
                        isCluster = true;
                        targetConfigName = cluster.getConfigRef();
                    }
                }
            }
            if (isDas) {
                this.loggingConfig.updateLoggingProperties(loggingProperties);
            } else if (targetConfigName != null && !targetConfigName.isEmpty() && (isCluster || isInstance || isConfig)) {
                this.loggingConfig.updateLoggingProperties(loggingProperties, targetConfigName);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = LOCAL_STRINGS.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", new Object[]{targetConfigName});
                report.setMessage(msg);
                return;
            }
            String successMsg = LOCAL_STRINGS.getLocalString("set.log.file.format.success", "The log file formatter is set to {0} for {1}.", new Object[]{formatterClassName, this.env.getInstanceName()});
            report.setMessage(successMsg);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException e) {
            report.setMessage(LOCAL_STRINGS.getLocalString("set.log.file.format.failed", "Could not set log file formatter for {0}.", new Object[]{this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

