/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class ShowTests {
    private TestFinder testFinder;
    private PrintStream out;
    private boolean nodes;
    private boolean fullTests;

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ShowTests.usage(System.out);
            } else {
                ShowTests m = new ShowTests();
                m.run(args);
            }
        }
        catch (BadArgs e) {
            System.err.println("Bad Arguments: " + e.getMessage());
            ShowTests.usage(System.err);
            System.exit(1);
        }
        catch (Fault f) {
            System.err.println("Error: " + f.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
            System.exit(3);
        }
    }

    private static void usage(PrintStream out) {
        String prog = System.getProperty("program", "java " + ShowTests.class.getName());
        out.println("Usage:");
        out.println("  " + prog + " [options]  test-suite");
        out.println("Options:");
        out.println("  -finder finderClass finderArgs... -end");
        out.println("                          specify the test finder to be used");
        out.println("  -initial initial-file   specify a starting point (optional)");
        out.println("  -o output-file          output file (default is standard output)");
        out.println("  -nodes                  show nodes in the tree");
        out.println("  -fulltests              show contents of tests");
    }

    public void run(String[] args) throws BadArgs, Fault, IOException {
        File testSuite = null;
        String finder = null;
        String[] finderArgs = null;
        File outFile = null;
        File initialFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-finder") && i + 1 < args.length) {
                finder = args[++i];
                int j = ++i;
                while (i < args.length - 1 && !args[i].equalsIgnoreCase("-end")) {
                    ++i;
                }
                finderArgs = new String[i - j];
                System.arraycopy(args, j, finderArgs, 0, finderArgs.length);
                continue;
            }
            if (args[i].equalsIgnoreCase("-initial") && i + 1 < args.length) {
                initialFile = new File(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-o") && i + 1 < args.length) {
                outFile = new File(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-nodes")) {
                this.nodes = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fulltests")) {
                this.fullTests = true;
                continue;
            }
            if (args[i].startsWith("-")) {
                throw new BadArgs(args[i]);
            }
            testSuite = new File(args[i]);
        }
        if (finder == null) {
            throw new BadArgs("no test finder specified");
        }
        if (testSuite == null) {
            throw new BadArgs("testsuite.html file not specified");
        }
        this.testFinder = this.initializeTestFinder(finder, finderArgs, testSuite);
        if (initialFile == null) {
            initialFile = this.testFinder.getRoot();
        }
        this.out = outFile == null ? System.out : new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        this.list(initialFile);
    }

    private TestFinder initializeTestFinder(String finder, String[] args, File ts) throws Fault {
        TestFinder testFinder;
        try {
            Class<?> c = Class.forName(finder);
            testFinder = (TestFinder)c.newInstance();
            testFinder.init(args, ts, null);
        }
        catch (ClassNotFoundException e) {
            throw new Fault("Error: Can't find class for TestFinder specified");
        }
        catch (InstantiationException e) {
            throw new Fault("Error: Can't create new instance of TestFinder");
        }
        catch (IllegalAccessException e) {
            throw new Fault("Error: Illegal Access Exception");
        }
        catch (TestFinder.Fault e) {
            throw new Fault("Error: Can't initialize test-finder: " + e.getMessage());
        }
        return testFinder;
    }

    private void list(File file) {
        int i;
        if (this.nodes) {
            this.out.println(file);
        }
        this.testFinder.read(file);
        TestDescription[] tests = this.testFinder.getTests();
        File[] files = this.testFinder.getFiles();
        if (tests != null) {
            for (i = 0; i < tests.length; ++i) {
                TestDescription td = tests[i];
                this.out.println("    " + td.getRootRelativeURL());
                if (!this.fullTests) continue;
                Iterator iter = td.getParameterKeys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = td.getParameter(key);
                    this.out.print("        ");
                    this.out.print(key);
                    this.pad(key, 15);
                    this.out.print(value);
                    this.out.println();
                }
            }
        }
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                this.list(files[i]);
            }
        }
    }

    void pad(String s, int length) {
        for (int i = s.length(); i < length; ++i) {
            this.out.write(32);
        }
        this.out.write(32);
    }

    public class Fault
    extends Exception {
        Fault(String msg) {
            super(msg);
        }
    }

    public class BadArgs
    extends Exception {
        BadArgs(String msg) {
            super(msg);
        }
    }
}

