/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XMLWriter {
    private BufferedWriter out;
    private int state;
    private I18NResourceBundle i18n;
    private DateFormat dateFormatter;
    private static final int IN_TAG = 1;
    private static final int IN_BODY = 2;

    public XMLWriter(Writer out) throws IOException {
        this(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    public XMLWriter(Writer out, String docType) throws IOException {
        this.out = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.out.write(docType);
        this.out.newLine();
    }

    public XMLWriter(Writer out, I18NResourceBundle i18n) throws IOException {
        this(out);
        this.i18n = i18n;
    }

    public XMLWriter(Writer out, String docType, I18NResourceBundle i18n) throws IOException {
        this(out, docType);
        this.i18n = i18n;
    }

    public void setI18NResourceBundle(I18NResourceBundle i18n) {
        this.i18n = i18n;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void newLine() throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        this.out.newLine();
    }

    public void startTag(String tag) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        this.out.write("<");
        this.out.write(tag);
        this.state = 1;
    }

    public void endTag(String tag) throws IOException {
        if (this.state == 1) {
            this.out.write("/>");
            this.state = 2;
        } else {
            this.out.write("</");
            this.out.write(tag);
            this.out.write(">");
        }
    }

    public void writeAttr(String name, String value) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(" ");
        this.out.write(name);
        this.out.write("=");
        this.out.write("\"");
        this.out.write(value);
        this.out.write("\"");
    }

    public void writeLine(String text) throws IOException {
        this.write(text);
        this.out.newLine();
    }

    public void writeDate(long millis) throws IOException {
        this.writeDate(new Date(millis));
    }

    public void writeDate(String tag, long millis) throws IOException {
        this.writeDate(tag, new Date(millis));
    }

    public void writeDate(Date date) throws IOException {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
        this.write(this.dateFormatter.format(date));
    }

    public void writeDate(String tag, Date date) throws IOException {
        this.startTag(tag);
        this.writeDate(date);
        this.endTag(tag);
    }

    public void write(String text) throws IOException {
        int i;
        if (text.length() == 0) {
            return;
        }
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        boolean specialChars = false;
        for (i = 0; i < text.length() && !specialChars; ++i) {
            switch (text.charAt(i)) {
                case '&': 
                case '<': 
                case '>': {
                    specialChars = true;
                }
            }
        }
        if (specialChars) {
            block9: for (i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '<': {
                        this.out.write("&lt;");
                        continue block9;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        continue block9;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        continue block9;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
        } else {
            this.out.write(text);
        }
    }

    public void write(I18NResourceBundle i18n, String key) throws IOException {
        this.write(i18n.getString(key));
    }

    public void write(I18NResourceBundle i18n, String key, Object arg) throws IOException {
        this.write(i18n.getString(key, arg));
    }

    public void write(I18NResourceBundle i18n, String key, Object[] args) throws IOException {
        this.write(i18n.getString(key, args));
    }

    public void writeI18N(String key) throws IOException {
        this.write(this.i18n.getString(key));
    }

    public void writeI18N(String key, Object arg) throws IOException {
        this.write(this.i18n.getString(key, arg));
    }

    public void writeI18N(String key, Object[] args) throws IOException {
        this.write(this.i18n.getString(key, args));
    }
}

