/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: StringBeanBinaryEncoder.java 70531 2013-03-10 14:38:04Z djiao $
 */

package com.sun.ts.tests.websocket.common.stringbean;

import java.nio.ByteBuffer;
import javax.websocket.EncodeException;
import javax.websocket.Encoder.Binary;
import javax.websocket.EndpointConfig;

public class StringBeanBinaryEncoder implements Binary<StringBean> {

    @Override
    public void init(EndpointConfig config) {
    }

    @Override
    public ByteBuffer encode(StringBean bean) throws EncodeException {
        return ByteBuffer.wrap(bean.get().getBytes());
    }

    @Override
    public void destroy() {
    }
}
