/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCErrorClientEndpoint.java 72818 2013-09-05 17:14:53Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpoint;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;

@ClientEndpoint
public class WSCErrorClientEndpoint extends AnnotatedClientEndpoint<String> {
	private static final String EXCEPTION = "TCK test throwable";

	boolean onErrorCalled = false;

	public WSCErrorClientEndpoint() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
		OPS op = OPS.valueOf(msg);
		switch (op) {
		case THROW:
			throw new RuntimeException(EXCEPTION);
		default:
			break;
		}
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		String msg = WebSocketCommonClient.getCauseMessage(t);
		if (EXCEPTION.equals(msg)) {
			onErrorCalled = true;
			getCountDownLatch().countDown();
		} else
			super.onError(session, t);
	}

}
