/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSDefaultMaxLengthClientEndpoint.java 72761 2013-08-30 17:06:49Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import java.lang.reflect.Method;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ClientEndpoint()
public class WSDefaultMaxLengthClientEndpoint extends
		AnnotatedClientEndpoint<String> {

	public WSDefaultMaxLengthClientEndpoint() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public String echo(String echo) {
		try {
			Method m = getClass().getMethod("echo", String.class);
			OnMessage onm = m.getAnnotation(OnMessage.class);
			long size = onm.maxMessageSize();
			String msg = String.valueOf(size);
			super.onMessage(msg);
			return msg;
		} catch (Exception e) {
			return IOUtil.printStackTrace(e);
		}
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}
}
