/*
 * Copyright (c) 2013, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: TCKClassLoader.java 74238 2014-12-08 15:18:12Z jsupol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.containerprovider.metainf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class TCKClassLoader extends ClassLoader {

	private ClassLoader orig;

	public TCKClassLoader(ClassLoader orig) {
		this.orig = orig;
	}

	@Override
	public Enumeration<URL> getResources(String name) throws IOException {
		Enumeration<URL> en = orig.getResources(name);
		return filter(en);
	}

	@Override
	public Class<?> loadClass(String name) throws ClassNotFoundException {
		return orig.loadClass(name);
	}

	@Override
	public boolean equals(Object obj) {
		return orig.equals(obj);
	}

	@Override
	public void clearAssertionStatus() {
		orig.clearAssertionStatus();
	}

	@Override
	public URL getResource(String name) {
		return orig.getResource(name);
	}

	@Override
	public InputStream getResourceAsStream(String name) {
		return orig.getResourceAsStream(name);
	}

	@Override
	public int hashCode() {
		return orig.hashCode();
	}

	private static Enumeration<URL> filter(Enumeration<URL> orig) {
		List<URL> list = new LinkedList<URL>();
		while (orig.hasMoreElements()) {
			URL url = orig.nextElement();
			String file = url.getFile();
			if (file.contains("lib.jar")
					&& file.contains("META-INF/services/javax.websocket.ContainerProvider"))
				list.add(url);
		}
		return Collections.enumeration(list);
	}
}
