/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSClient.java 72795 2013-09-04 15:47:07Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.containerprovider.vi;

import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 *                     ws_wait;
 */
public class WSClient extends WebSocketCommonClient {
	private static final long serialVersionUID = 4245245442874605867L;

	public WSClient() {
		setContextRoot("wsc_ee_containerprovider_vi_web");
	}

	public static void main(String[] args) {
		new WSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: getWebSocketContainerOnClientTest
	 * @assertion_ids: WebSocket:JAVADOC:28;
	 * @test_Strategy: ContainerProvider.getWebSocketContainer				  					
	 */
	public void getWebSocketContainerOnClientTest() throws Fault {
		WebSocketContainer container = ContainerProvider
				.getWebSocketContainer();
		assertNotNull(container,
				"ContainerProvider#getWebSocketContainer is null");
		logMsg("ContainerProvider#getWebSocketContainer obtained WebSocketContainer as expected");
	}

	/*
	 * @testName: getWebSocketContainerOnServerTest
	 * @assertion_ids: WebSocket:JAVADOC:28;
	 * @test_Strategy: ContainerProvider.getWebSocketContainer				  					
	 */
	public void getWebSocketContainerOnServerTest() throws Fault {
		invoke("srv", "anything", "true");
		logMsg("ContainerProvider#getWebSocketContainer obtained WebSocketContainer as expected");
	}

}
