/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.async;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import javax.websocket.EncodeException;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.WSCSuperEndpoint;

public abstract class WSCCommonServer implements WSCSuperEndpoint {
	public void onMessage(String msg, Session session) throws IOException,
			EncodeException, InterruptedException, ExecutionException {
		OPS op = OPS.valueOf(msg);
		Future<Void> future = null;
		switch (op) {
		case BOOL:
			future = session.getAsyncRemote().sendObject(BOOL);
			break;
		case BYTE:
			future = session.getAsyncRemote().sendObject(NUMERIC.byteValue());
			break;
		case CHAR:
			future = session.getAsyncRemote().sendObject(CHAR);
			break;
		case DOUBLE:
			future = session.getAsyncRemote().sendObject(NUMERIC.doubleValue());
			break;
		case FLOAT:
			future = session.getAsyncRemote().sendObject(NUMERIC.floatValue());
			break;
		case INT:
			future = session.getAsyncRemote().sendObject(NUMERIC.intValue());
			break;
		case LONG:
			future = session.getAsyncRemote().sendObject(NUMERIC.longValue());
			break;
		case SHORT:
			future = session.getAsyncRemote().sendObject(NUMERIC.shortValue());
			break;
		}
		future.get();
	}

	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in " + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}
}
