/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSUnusedServer.java 70543 2013-03-11 10:33:34Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverapplicationconfig;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/unused")
public class WSUnusedServer {

	@OnMessage
	public String echo(String echo){
		return echo;
	}
	
	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}	
}
