/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AlternativeInputStreamDecoder.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class AlternativeInputStreamDecoder implements Decoder.Binary<InputStream> {

	public static final String DECODER_SAYS = "InputStream decoder";

	@Override
	public void init(EndpointConfig config) {
	}

	@Override
	public void destroy() {
	}

	@Override
	public boolean willDecode(ByteBuffer bytes) {
		return true;
	}

	@Override
	public InputStream decode(ByteBuffer bytes) throws DecodeException {
		String s = DECODER_SAYS + IOUtil.byteBufferToString(bytes);
		ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
		return bais;
	}
}
