/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ThrowingTextStreamDecoder.java 72879 2013-09-19 15:25:02Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder;

import java.io.IOException;
import java.io.Reader;

import javax.websocket.DecodeException;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ThrowingTextStreamDecoder extends StringBeanTextStreamDecoder {

	@Override
	public StringBean decode(Reader r) throws DecodeException, IOException {
		String text = IOUtil.readFromReader(r);
		throw new DecodeException(text, ThrowingTextDecoder.ERR_MSG);
	}
}