/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCClientEndpointWithBinaryStreamEncoder.java 72879 2013-09-19 15:25:02Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.annotated;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingBinaryStreamEncoder;

@ClientEndpoint(encoders = ThrowingBinaryStreamEncoder.class)
public class WSCClientEndpointWithBinaryStreamEncoder extends
		AnnotatedClientEndpoint<String> {

	public WSCClientEndpointWithBinaryStreamEncoder() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config); // should throw on SendMessageCallback
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		String error = WebSocketCommonClient.getCauseMessage(t);
		onMessage(error);
		onMessage(error);
	}

}
