/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSDefaultMaxLengthServer.java 71263 2013-03-29 19:10:49Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;
import java.lang.reflect.Method;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/defaultmaxlen")
public class WSDefaultMaxLengthServer {

	@OnMessage
	public String echo(String echo){
		try {
			Method m = getClass().getMethod("echo", String.class);
			OnMessage onm = m.getAnnotation(OnMessage.class);
			long size = onm.maxMessageSize();
			return String.valueOf(size);
		} catch (Exception e) {
			return IOUtil.printStackTrace(e);
		}
	}
	
    @OnError
    public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in " + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);    }	
	
}
