/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSMaxLengthServer.java 71250 2013-03-29 16:35:32Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/maxlen")
public class WSMaxLengthServer {
	public static final String MSG = "maxMessageSize cased an exception as expected";

	@OnMessage(maxMessageSize=5L)
	public String echo(String echo){
		return echo;
	}
	
    @OnError
    public void onError(Session session, Throwable t) throws IOException {
    	String message = MSG + IOUtil.printStackTrace(t);
    	session.getBasicRemote().sendText(message);
    }	
	
}
