/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: TestListener.java 74522 2015-06-02 12:05:10Z jsupol $
 */
package com.sun.ts.tests.websocket.negdep.onmessage.ppsrv.nomoreendpoints;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.websocket.server.ServerContainer;

@WebListener
public class TestListener implements ServletContextListener {

        /**
         * Receives notification that the web application initialization
         * process is starting.
         *
         * @param sce The ServletContextEvent
         */
        @Override
        public void contextInitialized(ServletContextEvent sce) {
                ServletContext context = sce.getServletContext();
                try {
                        final ServerContainer serverContainer = (ServerContainer) context.getAttribute("javax.websocket.server.ServerContainer");
                        serverContainer.addEndpoint(new EchoServerConfig());
                } catch (Exception ex) {
                	//The DeploymentException can be thrown here, since no 
                	// more endpoit can be deployed when there was invalid 
                	// endpoint in the app
                	ex.printStackTrace();
                }
        }

        /**
         * Receives notification that the servlet context is about to be shut down.
         * @param sce The servlet context event
         */
        public void contextDestroyed(ServletContextEvent sce) {
                // Do nothing
        }
}
