/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AnnotatedOnOpenClientEndpoint.java 74493 2015-05-18 18:15:43Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onopen.client.toomanyargs;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;

@ClientEndpoint
public class AnnotatedOnOpenClientEndpoint extends
		AnnotatedStringClientEndpoint {

	@OnOpen
	public void onOpen(Session session, EndpointConfig config, Throwable throwable) {
		clientEndpoint.onOpen(session, config, false);
	}
	
	@OnMessage
	public void onMessage(String msg) {
		clientEndpoint.onMessage(msg);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		clientEndpoint.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		clientEndpoint.onError(session, t);
	}	
}
