/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: AnnotatedClientEndpointSubclassWithOverrideAndAnnotations.java 73530 2014-02-24 22:26:16Z supol $
 */

package com.sun.ts.tests.websocket.spec.annotation.inheritance;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

@ClientEndpoint
public class AnnotatedClientEndpointSubclassWithOverrideAndAnnotations extends
		AnnotatedClientEndpointSuperclassWithAnnotations {

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnMessage
	@Override
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

}
