/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackObjectSizeIndexHelper;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;

@Command(common=true, usage="usage_ObjectSizeIndex")
class ObjectSizeIndex
extends TextBuiltin {
    @Argument(index=0, required=true, usage="write, check")
    private String command;

    ObjectSizeIndex() {
    }

    @Override
    protected void run() throws IOException {
        switch (this.command) {
            case "write": {
                this.writeObjectSizeIndex();
                break;
            }
            case "check": {
                this.checkObjectSizeIndex();
                break;
            }
            default: {
                this.outw.println("Unknown command " + this.command);
            }
        }
    }

    private void writeObjectSizeIndex() throws IOException {
        if (!(this.db.getObjectDatabase() instanceof ObjectDirectory)) {
            throw ObjectSizeIndex.die("This repository object db doesn't have packs");
        }
        PackObjectSizeIndexHelper.forAllPacks((ObjectDirectory)((ObjectDirectory)this.db.getObjectDatabase()), (ProgressMonitor)new TextProgressMonitor());
    }

    private void checkObjectSizeIndex() throws IOException {
        if (!(this.db.getObjectDatabase() instanceof ObjectDirectory)) {
            throw ObjectSizeIndex.die("This repository object db doesn't have packs");
        }
        this.outw.println("Object size index configuration for this repo:");
        this.outw.println("\n* Writing:");
        this.printInt("pack", "minBytesForObjSizeIndex");
        this.outw.println("\n* Reading:");
        this.printBoolean("pack", "useObjectSizeIndex");
        this.outw.println("\n* Packs - have object size index:");
        for (Pack pack : ((ObjectDirectory)this.db.getObjectDatabase()).getPacks()) {
            String name = pack.getPackName();
            boolean hasObjectSizeIndex = pack.hasObjectSizeIndex();
            this.outw.println(String.format("  - %s - %b", name, hasObjectSizeIndex));
        }
    }

    private void printInt(String section, String name) throws IOException {
        Integer value = this.db.getConfig().getInt(section, name);
        String key = String.join((CharSequence)".", section, name);
        this.outw.println("  - " + key + " = " + String.valueOf(value));
    }

    private void printBoolean(String section, String name) throws IOException {
        Boolean value = this.db.getConfig().getBoolean(section, name);
        String key = String.join((CharSequence)".", section, name);
        this.outw.println("  - " + key + " = " + String.valueOf(value));
    }
}

