/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.provider.xmi;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecp.internal.view.model.provider.xmi.Activator;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;

public final class ViewModelFileExtensionsManager {
    private static final String FILTER_VALUE_ATTRIBUTE = "value";
    private static final String FILTER_KEY_ATTRIBUTE = "key";
    private static final String FILTER_ELEMENT = "filter";
    private static final String FILE_EXTENSION = "org.eclipse.emf.ecp.view.model.provider.xmi.file";
    private static final String FILEPATH_ATTRIBUTE = "filePath";
    private final Map<EClass, Map<VView, Map<String, String>>> map = new LinkedHashMap<EClass, Map<VView, Map<String, String>>>();
    private static ViewModelFileExtensionsManager instance;

    private ViewModelFileExtensionsManager() {
    }

    public static ViewModelFileExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ViewModelFileExtensionsManager();
            instance.init();
        }
        return instance;
    }

    private void init() {
        Map<URI, ExtensionDescription> extensionURIS = ViewModelFileExtensionsManager.getExtensionURIS();
        for (URI uri : extensionURIS.keySet()) {
            VView view;
            Resource resource = ViewModelFileExtensionsManager.loadResource(uri);
            EObject eObject = (EObject)resource.getContents().get(0);
            if (!(eObject instanceof VView) || (view = (VView)eObject).getRootEClass() == null) continue;
            ExtensionDescription extensionDescription = extensionURIS.get(uri);
            view.eAdapters().add((Object)new LocalizationAdapter(){

                public String localize(String key) {
                    return LocalizationServiceHelper.getString((Bundle)Platform.getBundle((String)extensionDescription.getBundleId()), (String)key);
                }
            });
            if (!this.map.containsKey(view.getRootEClass())) {
                this.map.put(view.getRootEClass(), new LinkedHashMap());
            }
            this.map.get(view.getRootEClass()).put(view, extensionDescription.getKeyValuPairs());
        }
    }

    public static Resource loadResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://org/eclipse/emf/ecp/view/model", (Object)VViewPackage.eINSTANCE);
        Resource resource = resourceSet.createResource(uri);
        HashMap loadOptions = new HashMap();
        try {
            resource.load(loadOptions);
        }
        catch (IOException exception) {
            Activator.getReportService().report(new AbstractReport((Throwable)exception));
        }
        return resource;
    }

    public static void dispose() {
        instance = null;
    }

    public static Map<URI, ExtensionDescription> getExtensionURIS() {
        LinkedHashMap<URI, ExtensionDescription> ret = new LinkedHashMap<URI, ExtensionDescription>();
        IConfigurationElement[] files = Platform.getExtensionRegistry().getConfigurationElementsFor(FILE_EXTENSION);
        URIConverter converter = new ResourceSetImpl().getURIConverter();
        IConfigurationElement[] iConfigurationElementArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement file = iConfigurationElementArray[n2];
            String bundleId = file.getContributor().getName();
            String filePath = file.getAttribute(FILEPATH_ATTRIBUTE);
            IConfigurationElement[] children = file.getChildren(FILTER_ELEMENT);
            LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray2 = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                String key = child.getAttribute(FILTER_KEY_ATTRIBUTE);
                String value = child.getAttribute(FILTER_VALUE_ATTRIBUTE);
                keyValuePairs.put(key, value);
                ++n4;
            }
            String bundleName = file.getContributor().getName();
            String path = String.valueOf(bundleName) + '/' + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            if (converter.exists(uri, null)) {
                ret.put(uri, new ExtensionDescription(keyValuePairs, bundleId));
            } else {
                uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
                if (converter.exists(uri, null)) {
                    ret.put(uri, new ExtensionDescription(keyValuePairs, bundleId));
                }
            }
            ++n2;
        }
        return ret;
    }

    public boolean hasViewModelFor(EObject eObject, Map<String, Object> context) {
        return this.map.containsKey(eObject.eClass());
    }

    public VView createView(EObject eObject, Map<String, Object> context) {
        Map<VView, Map<String, String>> viewMap = this.map.get(eObject.eClass());
        if (context == null) {
            return viewMap.keySet().iterator().next();
        }
        VView bestFitting = null;
        int maxNumberFittingKeyValues = -1;
        for (VView view : viewMap.keySet()) {
            Map<String, String> viewFilter = viewMap.get(view);
            int currentFittingKeyValues = 0;
            for (String viewFilterKey : viewFilter.keySet()) {
                if (context.containsKey(viewFilterKey)) {
                    Object contextValue = context.get(viewFilterKey);
                    String viewFilterValue = viewFilter.get(viewFilterKey);
                    if (contextValue.toString().equalsIgnoreCase(viewFilterValue)) {
                        ++currentFittingKeyValues;
                        continue;
                    }
                    currentFittingKeyValues = -1;
                    break;
                }
                currentFittingKeyValues = -1;
                break;
            }
            if (currentFittingKeyValues <= maxNumberFittingKeyValues) continue;
            maxNumberFittingKeyValues = currentFittingKeyValues;
            bestFitting = view;
        }
        Adapter adapter = (Adapter)bestFitting.eAdapters().get(0);
        VView copiedView = (VView)EcoreUtil.copy(bestFitting);
        copiedView.eAdapters().add((Object)adapter);
        return copiedView;
    }

    static final class ExtensionDescription {
        private final Map<String, String> keyValuPairs;
        private final String bundleId;

        private ExtensionDescription(Map<String, String> keyValuPairs, String bundleId) {
            this.keyValuPairs = keyValuPairs;
            this.bundleId = bundleId;
        }

        Map<String, String> getKeyValuPairs() {
            return this.keyValuPairs;
        }

        String getBundleId() {
            return this.bundleId;
        }
    }
}

