/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.DBOpEnvException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilenameUtils {
    static Logger LOG = LoggerFactory.getLogger(FilenameUtils.class);

    public static List<Path> scanForDirByPattern(Path directory, String namebase, String nameSep) {
        Pattern pattern = Pattern.compile(Pattern.quote(namebase) + Pattern.quote(nameSep) + "[\\d]+");
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, namebase + nameSep + "*");){
            for (Path entry : stream) {
                if (!pattern.matcher(entry.getFileName().toString()).matches()) {
                    throw new DBOpEnvException("Invalid filename for matching: " + entry.getFileName());
                }
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    throw new DBOpEnvException("Not a directory: " + entry);
                }
                paths.add(entry);
            }
        }
        catch (IOException ex) {
            FmtLog.warn(LOG, "Can't inspect directory: (%s, %s)", directory, namebase);
            throw new DBOpEnvException(ex);
        }
        Comparator comp = (f1, f2) -> {
            int num1 = FilenameUtils.extractIndex(f1.getFileName().toString(), namebase, nameSep);
            int num2 = FilenameUtils.extractIndex(f2.getFileName().toString(), namebase, nameSep);
            return Integer.compare(num1, num2);
        };
        paths.sort(comp);
        return paths;
    }

    public static int extractIndex(String name, String namebase, String nameSep) {
        int i = namebase.length() + nameSep.length();
        String numStr = name.substring(i);
        int num = Integer.parseInt(numStr);
        return num;
    }

    public static String filename(String prefix, String sep, int N) {
        return String.format("%s%s%04d", prefix, sep, N);
    }

    public static String filename(String prefix, String sep, String index) {
        return String.format("%s%s%s", prefix, sep, index);
    }
}

