/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.commons;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.api.ConfigurationParameter;
import org.junit.platform.suite.api.DisableParentConfigurationParameters;
import org.junit.platform.suite.api.ExcludeClassNamePatterns;
import org.junit.platform.suite.api.ExcludeEngines;
import org.junit.platform.suite.api.ExcludePackages;
import org.junit.platform.suite.api.ExcludeTags;
import org.junit.platform.suite.api.IncludeClassNamePatterns;
import org.junit.platform.suite.api.IncludeEngines;
import org.junit.platform.suite.api.IncludePackages;
import org.junit.platform.suite.api.IncludeTags;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.SelectClasspathResource;
import org.junit.platform.suite.api.SelectDirectories;
import org.junit.platform.suite.api.SelectFile;
import org.junit.platform.suite.api.SelectMethod;
import org.junit.platform.suite.api.SelectModules;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.SelectUris;
import org.junit.platform.suite.commons.AdditionalDiscoverySelectors;

@API(status=API.Status.INTERNAL, since="1.8", consumers={"org.junit.platform.suite.engine", "org.junit.platform.runner"})
public final class SuiteLauncherDiscoveryRequestBuilder {
    private final LauncherDiscoveryRequestBuilder delegate = LauncherDiscoveryRequestBuilder.request();
    private final Set<String> selectedClassNames = new LinkedHashSet<String>();
    private boolean includeClassNamePatternsUsed;
    private boolean filterStandardClassNamePatterns = false;
    private ConfigurationParameters parentConfigurationParameters;
    private boolean enableParentConfigurationParameters = true;

    private SuiteLauncherDiscoveryRequestBuilder() {
    }

    public static SuiteLauncherDiscoveryRequestBuilder request() {
        return new SuiteLauncherDiscoveryRequestBuilder();
    }

    public SuiteLauncherDiscoveryRequestBuilder selectors(DiscoverySelector ... selectors) {
        this.delegate.selectors(selectors);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder selectors(List<? extends DiscoverySelector> selectors) {
        this.delegate.selectors(selectors);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder filters(Filter<?> ... filters) {
        this.delegate.filters(filters);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder filterStandardClassNamePatterns(boolean filterStandardClassNamePatterns) {
        this.filterStandardClassNamePatterns = filterStandardClassNamePatterns;
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder configurationParameter(String key, String value) {
        this.delegate.configurationParameter(key, value);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder configurationParameters(Map<String, String> configurationParameters) {
        this.delegate.configurationParameters(configurationParameters);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder parentConfigurationParameters(ConfigurationParameters parentConfigurationParameters) {
        this.parentConfigurationParameters = parentConfigurationParameters;
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder enableImplicitConfigurationParameters(boolean enabled) {
        this.delegate.enableImplicitConfigurationParameters(enabled);
        return this;
    }

    @Deprecated
    public SuiteLauncherDiscoveryRequestBuilder suite(Class<?> suiteClass) {
        Preconditions.notNull(suiteClass, "Suite class must not be null");
        this.applyConfigurationParametersFromSuite(suiteClass);
        this.applySelectorsAndFiltersFromSuite(suiteClass);
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder applyConfigurationParametersFromSuite(Class<?> suiteClass) {
        Preconditions.notNull(suiteClass, "Suite class must not be null");
        AnnotationUtils.findRepeatableAnnotations(suiteClass, ConfigurationParameter.class).forEach(configuration -> this.configurationParameter(configuration.key(), configuration.value()));
        AnnotationUtils.findAnnotation(suiteClass, DisableParentConfigurationParameters.class).ifPresent(__ -> {
            this.enableParentConfigurationParameters = false;
        });
        return this;
    }

    public SuiteLauncherDiscoveryRequestBuilder applySelectorsAndFiltersFromSuite(Class<?> suiteClass) {
        Preconditions.notNull(suiteClass, "Suite class must not be null");
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludeClassNamePatterns.class, ExcludeClassNamePatterns::value).flatMap(SuiteLauncherDiscoveryRequestBuilder::trimmed).map(ClassNameFilter::excludeClassNamePatterns).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludeEngines.class, ExcludeEngines::value).map(EngineFilter::excludeEngines).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludePackages.class, ExcludePackages::value).map(PackageNameFilter::excludePackageNames).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, ExcludeTags.class, ExcludeTags::value).map(TagFilter::excludeTags).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        AnnotationUtils.findAnnotation(suiteClass, SelectClasses.class).map(annotation -> this.selectClasses(suiteClass, (SelectClasses)annotation)).ifPresent(this::selectors);
        AnnotationUtils.findRepeatableAnnotations(suiteClass, SelectMethod.class).stream().map(annotation -> this.selectMethod(suiteClass, (SelectMethod)annotation)).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludeClassNamePatterns.class, IncludeClassNamePatterns::value).flatMap(SuiteLauncherDiscoveryRequestBuilder::trimmed).map(this::createIncludeClassNameFilter).ifPresent(filters -> {
            this.includeClassNamePatternsUsed = true;
            this.filters((Filter<?>)filters);
        });
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludeEngines.class, IncludeEngines::value).map(EngineFilter::includeEngines).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludePackages.class, IncludePackages::value).map(PackageNameFilter::includePackageNames).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, IncludeTags.class, IncludeTags::value).map(TagFilter::includeTags).ifPresent(xva$0 -> this.filters((Filter<?>)xva$0));
        AnnotationUtils.findRepeatableAnnotations(suiteClass, SelectClasspathResource.class).stream().map(annotation -> AdditionalDiscoverySelectors.selectClasspathResource(annotation.value(), annotation.line(), annotation.column())).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectDirectories.class, SelectDirectories::value).map(AdditionalDiscoverySelectors::selectDirectories).ifPresent(this::selectors);
        AnnotationUtils.findRepeatableAnnotations(suiteClass, SelectFile.class).stream().map(annotation -> AdditionalDiscoverySelectors.selectFile(annotation.value(), annotation.line(), annotation.column())).forEach(xva$0 -> this.selectors((DiscoverySelector)xva$0));
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectModules.class, SelectModules::value).map(AdditionalDiscoverySelectors::selectModules).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectUris.class, SelectUris::value).map(AdditionalDiscoverySelectors::selectUris).ifPresent(this::selectors);
        SuiteLauncherDiscoveryRequestBuilder.findAnnotationValues(suiteClass, SelectPackages.class, SelectPackages::value).map(AdditionalDiscoverySelectors::selectPackages).ifPresent(this::selectors);
        return this;
    }

    public LauncherDiscoveryRequest build() {
        if (this.filterStandardClassNamePatterns && !this.includeClassNamePatternsUsed) {
            this.delegate.filters(this.createIncludeClassNameFilter("^(Test.*|.+[.$]Test.*|.*Tests?)$"));
        }
        if (this.enableParentConfigurationParameters && this.parentConfigurationParameters != null) {
            this.delegate.parentConfigurationParameters(this.parentConfigurationParameters);
        }
        return this.delegate.build();
    }

    private List<ClassSelector> selectClasses(Class<?> suiteClass, SelectClasses annotation) {
        return SuiteLauncherDiscoveryRequestBuilder.toClassSelectors(suiteClass, annotation).distinct().peek(selector -> this.selectedClassNames.add(selector.getClassName())).collect(Collectors.toList());
    }

    private static Stream<ClassSelector> toClassSelectors(Class<?> suiteClass, SelectClasses annotation) {
        Preconditions.condition(annotation.value().length > 0 || annotation.names().length > 0, () -> String.format("@SelectClasses on class [%s] must declare at least one class reference or name", suiteClass.getName()));
        return Stream.concat(AdditionalDiscoverySelectors.selectClasses(annotation.value()), AdditionalDiscoverySelectors.selectClasses(annotation.names()));
    }

    private MethodSelector selectMethod(Class<?> suiteClass, SelectMethod annotation) {
        MethodSelector methodSelector = this.toMethodSelector(suiteClass, annotation);
        this.selectedClassNames.add(methodSelector.getClassName());
        return methodSelector;
    }

    private MethodSelector toMethodSelector(Class<?> suiteClass, SelectMethod annotation) {
        if (!annotation.value().isEmpty()) {
            Preconditions.condition(annotation.type() == Class.class, () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "type must not be set in conjunction with fully qualified method name"));
            Preconditions.condition(annotation.typeName().isEmpty(), () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "type name must not be set in conjunction with fully qualified method name"));
            Preconditions.condition(annotation.name().isEmpty(), () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "method name must not be set in conjunction with fully qualified method name"));
            Preconditions.condition(annotation.parameterTypes().length == 0, () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "parameter types must not be set in conjunction with fully qualified method name"));
            Preconditions.condition(annotation.parameterTypeNames().isEmpty(), () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "parameter type names must not be set in conjunction with fully qualified method name"));
            return DiscoverySelectors.selectMethod(annotation.value());
        }
        Class<?> type = annotation.type() == Class.class ? null : annotation.type();
        String typeName = annotation.typeName().isEmpty() ? null : annotation.typeName().trim();
        String methodName = Preconditions.notBlank(annotation.name(), () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "method name must not be blank"));
        Class<?>[] parameterTypes = annotation.parameterTypes().length == 0 ? null : annotation.parameterTypes();
        String parameterTypeNames = annotation.parameterTypeNames().trim();
        if (parameterTypes != null) {
            Preconditions.condition(parameterTypeNames.isEmpty(), () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "either parameter type names or parameter types must be set but not both"));
        }
        if (type == null) {
            Preconditions.notBlank(typeName, () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "type must be set or type name must not be blank"));
            if (parameterTypes == null) {
                return DiscoverySelectors.selectMethod(typeName, methodName, parameterTypeNames);
            }
            return DiscoverySelectors.selectMethod(typeName, methodName, parameterTypes);
        }
        Preconditions.condition(typeName == null, () -> SuiteLauncherDiscoveryRequestBuilder.prefixErrorMessageForInvalidSelectMethodUsage(suiteClass, "either type name or type must be set but not both"));
        if (parameterTypes == null) {
            return DiscoverySelectors.selectMethod(type, methodName, parameterTypeNames);
        }
        return DiscoverySelectors.selectMethod(type, methodName, parameterTypes);
    }

    private static String prefixErrorMessageForInvalidSelectMethodUsage(Class<?> suiteClass, String detailMessage) {
        return String.format("@SelectMethod on class [%s]: %s", suiteClass.getName(), detailMessage);
    }

    private ClassNameFilter createIncludeClassNameFilter(String ... patterns) {
        String[] combinedPatterns = (String[])Stream.concat(this.selectedClassNames.stream().map(Pattern::quote), Arrays.stream(patterns)).toArray(String[]::new);
        return ClassNameFilter.includeClassNamePatterns(combinedPatterns);
    }

    private static <A extends Annotation, V> Optional<V[]> findAnnotationValues(AnnotatedElement element, Class<A> annotationType, Function<A, V[]> valueExtractor) {
        return AnnotationUtils.findAnnotation(element, annotationType).map(valueExtractor).filter(values -> ((Object[])values).length > 0);
    }

    private static Optional<String[]> trimmed(String[] patterns) {
        if (patterns.length == 0) {
            return Optional.empty();
        }
        return Optional.of((String[])Arrays.stream(patterns).filter(StringUtils::isNotBlank).map(String::trim).toArray(String[]::new));
    }
}

