/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_WRITE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Task_INCREMENT_WRITE
extends AbstractTask
implements ITaskListener {
    public static final String TASKNAME = "Task_INCREMENT_WRITE";
    private static final int STANDBY = 0;
    private static final int WRITE_TAG_STARTED = 1;
    private int writeOpId;
    private int memoryBank;
    private int wordPointer;
    private int password;
    private String baseWriteData;
    private int increment;
    private int repeat;
    private long timeout;
    private String operationId;
    private Task_DELETE_EXIST_ACCESSSPEC deleteExistAccessSpecTask;
    private Task_ADD_ACCESSSPEC addAccessSpecTask;
    private Task_ENABLE_ACCESSSPEC enableAccessSpecTask;
    private SignalService rOAccessReport;
    private Task_WRITE_TAG writeTagTask;
    private List accessOpList;
    private int successCount = 0;

    public Task_INCREMENT_WRITE(int writeOpId, int memoryBank, int wordPointer, int password, String baseWriteData, int increment, int repeat, long timeout, Task_DELETE_EXIST_ACCESSSPEC deleteExistAccessSpecTask, Task_ADD_ACCESSSPEC addAccessSpecTask, Task_ENABLE_ACCESSSPEC enableAccessSpecTask, SignalService rOAccessReport, String operationId) {
        this.writeOpId = writeOpId;
        this.memoryBank = memoryBank;
        this.wordPointer = wordPointer;
        this.password = password;
        this.baseWriteData = baseWriteData;
        this.increment = increment;
        this.repeat = repeat;
        this.timeout = timeout;
        this.deleteExistAccessSpecTask = deleteExistAccessSpecTask;
        this.addAccessSpecTask = addAccessSpecTask;
        this.enableAccessSpecTask = enableAccessSpecTask;
        this.rOAccessReport = rOAccessReport;
        this.accessOpList = this.getAccessOpList();
        this.operationId = operationId;
        this.writeTagTask = new Task_WRITE_TAG(this.writeOpId, this.deleteExistAccessSpecTask, this.addAccessSpecTask, this.enableAccessSpecTask, this.rOAccessReport, this.timeout, this.operationId);
        this.writeTagTask.addTaskListener(this);
        this.setState(0);
    }

    public boolean duplicateTask(ITask task) {
        return task instanceof Task_INCREMENT_WRITE;
    }

    private boolean fillWriteOp() {
        try {
            int incrementValue = this.successCount * this.increment;
            String currentWriteData = LLRPUtils.hexStrIncrement(this.baseWriteData, incrementValue);
            Map writeOpParameters = ParameterFactory.getC1G2WriteParameter(this.writeOpId, this.password, this.memoryBank, this.wordPointer, currentWriteData);
            if (this.accessOpList != null) {
                this.accessOpList.clear();
                this.accessOpList.add(writeOpParameters);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            if (this.isLogging(4)) {
                this.log(4, "NumberFormatException: " + e.toString());
            }
            return false;
        }
    }

    private List getAccessOpList() {
        List accessCommandOpSpecChoice;
        Map accessCommandParameters;
        Map accessSpecParameters;
        Map addAccessSpecParameters;
        if (this.addAccessSpecTask != null && (addAccessSpecParameters = this.addAccessSpecTask.getParameters()) != null && (accessSpecParameters = (Map)addAccessSpecParameters.get("AccessSpecParameter")) != null && (accessCommandParameters = (Map)accessSpecParameters.get("AccessCommandParameter")) != null && (accessCommandOpSpecChoice = (List)accessCommandParameters.get("AccessCommandOpSpecChoice")) != null) {
            return accessCommandOpSpecChoice;
        }
        return null;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        switch (this.getState()) {
            case 1: {
                this.writeTagTask.handleResponse(source, timestamp, data);
                return;
            }
        }
    }

    public boolean isResponseExpected(SignalService source, Object timestamp, Object data) {
        switch (this.getState()) {
            case 1: {
                if (this.writeTagTask.getTaskManager() != null && this.writeTagTask.getTaskManager() != this.getTaskManager()) {
                    return false;
                }
                return this.writeTagTask.isResponseExpected(source, timestamp, data);
            }
        }
        return false;
    }

    public synchronized boolean launchTask() {
        if (this.fillWriteOp() && this.deleteExistAccessSpecTask != null && this.addAccessSpecTask != null && this.enableAccessSpecTask != null && this.rOAccessReport != null) {
            this.setState(1);
            this.writeTagTask.start();
            return true;
        }
        return false;
    }

    public synchronized void taskNotice(String taskName, int status, Object result) {
        if (status == 0) {
            this.notifyListener(this.getTaskName(), status, result);
            return;
        }
        if (taskName.equals(this.writeTagTask.getTaskName())) {
            switch (status) {
                case 3: {
                    if (this.isLogging(4)) {
                        this.log(4, "Write tag report in Increment Write.");
                    }
                    this.notifyListener(taskName, 3, result);
                    return;
                }
                case 1: {
                    if (this.isLogging(4)) {
                        this.log(4, "Write tag succeeded in Increment Write.");
                    }
                    ++this.successCount;
                    if (this.successCount < this.repeat && this.fillWriteOp()) {
                        this.setState(1);
                        this.writeTagTask.start();
                    } else {
                        this.setState(0);
                        this.notifyListener(this.getTaskName(), 1, result);
                    }
                    return;
                }
                case 2: {
                    if (this.isLogging(4)) {
                        this.log(4, "Write tag timeout in Increment Write.");
                    }
                    this.setState(0);
                    this.notifyListener(this.getTaskName(), 2, result);
                    return;
                }
            }
        }
    }
}

