/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;

public class StreamConnection
extends Connection
implements ConnectionService {
    private InputStream inputStream;
    private OutputStream outputStream;

    public StreamConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public StreamConnection(Dictionary properties) {
        super(properties);
    }

    public StreamConnection() {
    }

    public synchronized void close() throws IOException {
        InputStream inputStream;
        this.setOpen(false);
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setOutputStream(null);
        }
        if ((inputStream = this.getInputStream()) != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setInputStream(null);
        }
    }

    public void flush() throws IOException {
        this.getOutputStream().flush();
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int read(byte[] bytes) throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            int readCount = inputStream.read(bytes);
            this.updateReadByteCount(readCount);
            return readCount;
        }
        return -1;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            int readCount = inputStream.read(bytes, offset, length);
            this.updateReadByteCount(readCount);
            return readCount;
        }
        return -1;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void write(byte[] bytes) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            outputStream.write(bytes);
            this.updateWriteByteCount(bytes.length);
        }
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            outputStream.write(bytes, offset, count);
            this.updateWriteByteCount(count);
        }
    }
}

