/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.profile.service.MultiplexProfileListener;
import org.eclipse.soda.dk.profile.service.ProfileListener;
import org.eclipse.soda.dk.profile.service.ProfileService;

public class ProfileListeners
extends EscObject
implements MultiplexProfileListener {
    private ProfileListener[] objects;

    public ProfileListeners(ProfileListener currentObject, ProfileListener newObject) {
        if (currentObject instanceof ProfileListeners) {
            ProfileListeners currentMulticaster = (ProfileListeners)currentObject;
            ProfileListener[] oldList = currentMulticaster.getObjects();
            this.objects = new ProfileListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new ProfileListener[]{currentObject, newObject};
        }
    }

    public ProfileListeners(ProfileListener[] objects) {
        this.setObjects(objects);
    }

    public static ProfileListener add(ProfileListener currentObject, ProfileListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new ProfileListeners(currentObject, newObject);
    }

    public static ProfileListener remove(ProfileListener currentObject, ProfileListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof ProfileListeners) {
            return ((ProfileListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public void channelChanged(ProfileService source, Object timestamp, ChannelService channel, int newState, int oldState) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                MultiplexProfileListener listener = (MultiplexProfileListener)this.objects[i];
                listener.channelChanged(source, timestamp, channel, newState, oldState);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public void controlChanged(ProfileService container, Object timestamp, ControlService control, int code) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].controlChanged(container, timestamp, control, code);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public ProfileListener[] getObjects() {
        return this.objects;
    }

    public void profileChanged(ProfileService source, Object timestamp, int newState, int oldState) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].profileChanged(source, timestamp, newState, oldState);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    protected ProfileListener remove(ProfileListener removeHandler) {
        ProfileListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        ProfileListener[] newList = new ProfileListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new ProfileListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(ProfileListener[] objects) {
        this.objects = objects;
    }
}

