/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.equinox.internal.useradmin.Group;
import org.eclipse.equinox.internal.useradmin.LogTracker;
import org.eclipse.equinox.internal.useradmin.Role;
import org.eclipse.equinox.internal.useradmin.User;
import org.eclipse.equinox.internal.useradmin.UserAdmin;
import org.eclipse.equinox.internal.useradmin.UserAdminHashtable;
import org.eclipse.equinox.internal.useradmin.UserAdminMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class UserAdminStore {
    protected static final String propertiesNode = "properties";
    protected static final String credentialsNode = "credentials";
    protected static final String membersNode = "members";
    private static final String typesNode = "types";
    protected static final String basicString = "basic";
    protected static final String requiredString = "required";
    protected static final String typeString = "type";
    protected static final String persistenceUserName = "UserAdmin";
    protected ServiceReference prefsRef;
    protected ServiceRegistration userAdminListenerReg;
    protected UserAdmin useradmin;
    protected LogTracker log;
    protected Preferences rootNode;
    protected PreferencesService preferencesService;

    protected UserAdminStore(PreferencesService preferencesService, UserAdmin useradmin, LogTracker log) {
        this.preferencesService = preferencesService;
        this.useradmin = useradmin;
        this.log = log;
    }

    protected void init() throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                this.rootNode = this.preferencesService.getUserPreferences(persistenceUserName);
                this.loadRoles();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void addRole(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences node = this.rootNode.node(role.getName());
                node.putInt(typeString, role.getType());
                node.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void removeRole(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences node = this.rootNode.node(role.getName());
                node.removeNode();
                this.rootNode.node("").flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void clearProperties(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences propertyNode = this.rootNode.node(role.getName() + "/properties");
                propertyNode.clear();
                if (propertyNode.nodeExists(typesNode)) {
                    propertyNode.node(typesNode).removeNode();
                }
                propertyNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void addProperty(org.osgi.service.useradmin.Role role, String key, Object value) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences propertyNode = this.rootNode.node(role.getName() + "/properties");
                Preferences propertyTypesNode = propertyNode.node(typesNode);
                if (value instanceof String) {
                    propertyNode.put(key, (String)value);
                    propertyTypesNode.putBoolean(key, true);
                } else {
                    propertyNode.putByteArray(key, (byte[])value);
                    propertyTypesNode.putBoolean(key, false);
                }
                propertyNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void removeProperty(org.osgi.service.useradmin.Role role, String key) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences propertyNode = this.rootNode.node(role.getName() + "/properties");
                propertyNode.remove(key);
                if (propertyNode.nodeExists(typesNode)) {
                    propertyNode.node(typesNode).remove(key);
                }
                propertyNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void clearCredentials(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences credentialNode = this.rootNode.node(role.getName() + "/credentials");
                credentialNode.clear();
                if (credentialNode.nodeExists(typesNode)) {
                    credentialNode.node(typesNode).removeNode();
                }
                credentialNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void addCredential(org.osgi.service.useradmin.Role role, String key, Object value) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences credentialNode = this.rootNode.node(role.getName() + "/credentials");
                Preferences credentialTypesNode = credentialNode.node(typesNode);
                if (value instanceof String) {
                    credentialNode.put(key, (String)value);
                    credentialTypesNode.putBoolean(key, true);
                } else {
                    credentialNode.putByteArray(key, (byte[])value);
                    credentialTypesNode.putBoolean(key, false);
                }
                credentialNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object)NLS.bind((String)UserAdminMsg.adding_Credential_to__15, (Object)role.getName())), ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void removeCredential(org.osgi.service.useradmin.Role role, String key) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences credentialNode = this.rootNode.node(role.getName() + "/credentials");
                credentialNode.remove(key);
                if (credentialNode.nodeExists(typesNode)) {
                    credentialNode.node(typesNode).remove(key);
                }
                credentialNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void addMember(Group group, Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences memberNode = this.rootNode.node(group.getName() + "/members");
                memberNode.put(role.getName(), basicString);
                memberNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object)NLS.bind((String)UserAdminMsg.adding_member__18, (Object)role.getName(), (Object)group.getName())), ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void addRequiredMember(Group group, Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences memberNode = this.rootNode.node(group.getName() + "/members");
                memberNode.put(role.getName(), requiredString);
                memberNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.adding_required_member__21, (Object)role.getName(), (Object)group.getName())}), ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    protected void removeMember(Group group, Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences memberNode = this.rootNode.node(group.getName() + "/members");
                memberNode.remove(role.getName());
                memberNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.error(NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.removing_member__24, (Object)role.getName(), (Object)group.getName())}), ex);
            throw (BackingStoreException)((Object)ex.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRoles() throws BackingStoreException {
        UserAdminStore userAdminStore = this;
        synchronized (userAdminStore) {
            String[] children;
            this.createAnonRole();
            String[] stringArray = children = this.rootNode.node("").childrenNames();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                if (this.useradmin.getRole(child) == null) {
                    this.loadRole(this.rootNode.node(child), null);
                }
                ++n2;
            }
        }
    }

    protected void loadRole(Preferences node, Role role) throws BackingStoreException {
        Object value;
        int type = node.getInt(typeString, Integer.MIN_VALUE);
        if (type == Integer.MIN_VALUE) {
            String errorString = NLS.bind((String)UserAdminMsg.Backing_Store_Read_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.Unable_to_load_role__27, (Object)node.name())});
            BackingStoreException ex = new BackingStoreException(errorString);
            this.log.error(errorString, ex);
            throw ex;
        }
        if (role == null) {
            role = (Role)this.useradmin.createRole(node.name(), type, false);
        }
        Preferences propsNode = node.node(propertiesNode);
        String[] keys = propsNode.keys();
        UserAdminHashtable properties = (UserAdminHashtable)role.getProperties();
        Preferences propsTypesNode = propsNode.node(typesNode);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            value = propsTypesNode.getBoolean(key, true) ? propsNode.get(key, null) : (Object)propsNode.getByteArray(key, null);
            properties.put(key, value, false);
            ++n2;
        }
        if (type == 1 || type == 2) {
            Preferences credNode = node.node(credentialsNode);
            Preferences credTypesNode = credNode.node(typesNode);
            keys = credNode.keys();
            UserAdminHashtable credentials = (UserAdminHashtable)((User)role).getCredentials();
            String[] stringArray2 = keys;
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                String key = stringArray2[n4];
                Object credValue = credTypesNode.getBoolean(key, true) ? credNode.get(key, null) : (Object)credNode.getByteArray(key, null);
                credentials.put(key, credValue, false);
                ++n4;
            }
        }
        if (type == 2) {
            Preferences memberNode = node.node(membersNode);
            String[] stringArray3 = keys = memberNode.keys();
            int n5 = keys.length;
            n = 0;
            while (n < n5) {
                String key = stringArray3[n];
                value = memberNode.get(key, null);
                Role member = (Role)this.useradmin.getRole(key);
                if (member == null) {
                    this.loadRole(this.rootNode.node(key), null);
                    member = (Role)this.useradmin.getRole(key);
                }
                if (value.equals(requiredString)) {
                    ((Group)role).addRequiredMember(member, false);
                } else {
                    ((Group)role).addMember(member, false);
                }
                ++n;
            }
        }
    }

    protected void destroy() {
        try {
            this.rootNode.flush();
            this.rootNode = null;
            this.preferencesService = null;
        }
        catch (BackingStoreException ex) {
            this.log.error(UserAdminMsg.Backing_Store_Write_Exception, ex);
        }
    }

    private void createAnonRole() throws BackingStoreException {
        Role role = null;
        if (!this.rootNode.nodeExists("user.anyone")) {
            role = (Role)this.useradmin.createRole("user.anyone", 0, true);
        }
        if (role != null) {
            this.loadRole(this.rootNode.node("user.anyone"), role);
        } else {
            this.loadRole(this.rootNode.node("user.anyone"), null);
        }
    }
}

