/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import java.util.Hashtable;
import org.eclipse.equinox.internal.useradmin.UserAdmin;
import org.eclipse.equinox.internal.useradmin.UserAdminEventAdapter;
import org.eclipse.equinox.internal.useradmin.UserAdminMsg;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceFactory,
ServiceTrackerCustomizer {
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    protected ServiceRegistration registration;
    protected UserAdmin userAdmin;
    protected static String userAdminClazz = "org.osgi.service.useradmin.UserAdmin";
    protected PreferencesService prefs;
    protected BundleContext context;
    protected ServiceTracker prefsTracker;
    protected UserAdminEventAdapter eventAdapter;

    public void start(BundleContext context_) throws Exception {
        this.context = context_;
        this.prefsTracker = new ServiceTracker(this.context, PreferencesService.class.getName(), (ServiceTrackerCustomizer)this);
        this.prefsTracker.open();
        if (Activator.checkEventAdmin()) {
            this.eventAdapter = new UserAdminEventAdapter(context_);
            this.eventAdapter.start();
        }
    }

    private static boolean checkEventAdmin() {
        try {
            Class.forName(EVENT_ADMIN_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void stop(BundleContext context_) throws Exception {
        if (this.eventAdapter != null) {
            this.eventAdapter.stop();
            this.eventAdapter = null;
        }
        this.prefsTracker.close();
        this.unregisterUserAdminService();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration_) {
        this.userAdmin.setServiceReference(registration_.getReference());
        return this.userAdmin;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration_, Object service) {
    }

    public Object addingService(ServiceReference reference) {
        if (this.prefs == null) {
            this.prefs = (PreferencesService)this.context.getService(reference);
            try {
                this.registerUserAdminService();
            }
            catch (Exception ex) {
                return null;
            }
            return this.prefs;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.prefs) {
            this.prefs = null;
            this.unregisterUserAdminService();
        }
        this.context.ungetService(reference);
    }

    protected void registerUserAdminService() throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", UserAdminMsg.Service_Vendor);
        properties.put("service.description", UserAdminMsg.OSGi_User_Admin_service_IBM_Implementation_3);
        properties.put("service.pid", this.getClass().getName());
        this.userAdmin = new UserAdmin(this.prefs, this.context);
        this.registration = this.context.registerService(userAdminClazz, (Object)this, properties);
        this.userAdmin.setServiceReference(this.registration.getReference());
    }

    protected void unregisterUserAdminService() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
            this.userAdmin.destroy();
            this.userAdmin = null;
        }
    }
}

