/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.stateviz;

import java.util.stream.IntStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

public class StateVisualizerColumnWidthSupport {
    private final TableColumn column;
    private final Image image;
    private final GC gc;
    private final int[] widths = IntStream.generate(() -> -1).limit(256L).toArray();
    private int curWidth;
    private int newWidth = -1;
    private int valueColumnExtraWidth = -1;
    private long lastWidthChangeTime = System.currentTimeMillis();

    public StateVisualizerColumnWidthSupport(TableColumn column) {
        this.column = column;
        this.curWidth = column.getWidth();
        this.image = new Image((Device)column.getDisplay(), 1, 1);
        this.gc = new GC((Drawable)this.image);
        this.gc.setFont(column.getParent().getFont());
    }

    private int getTextWidth(String text) {
        int calc = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            Assert.check((c >= '\u0000' && c < this.widths.length ? 1 : 0) != 0);
            int l = this.widths[c];
            if (l == -1) {
                this.widths[c] = l = this.gc.textExtent((String)String.valueOf((char)c)).x;
            }
            calc += l;
            ++i;
        }
        return calc + 4;
    }

    private void setWidth(int width) {
        this.column.setWidth(width);
        this.curWidth = width;
        this.lastWidthChangeTime = System.currentTimeMillis();
    }

    public void initNewWidth() {
        this.newWidth = this.getTextWidth(this.column.getText());
    }

    public void updateNewWidth(String cellText) {
        this.newWidth = Math.max(this.newWidth, this.getTextWidth(cellText));
    }

    public void applyNewWidth() {
        if (this.valueColumnExtraWidth == -1) {
            this.column.pack();
            this.valueColumnExtraWidth = this.column.getWidth() - this.newWidth;
            this.valueColumnExtraWidth = Math.max(0, this.valueColumnExtraWidth);
        } else {
            this.newWidth += this.valueColumnExtraWidth;
            if (this.newWidth > this.curWidth) {
                this.setWidth(this.newWidth);
            } else if (this.newWidth < this.curWidth && System.currentTimeMillis() - this.lastWidthChangeTime > 1000L) {
                this.setWidth(this.newWidth);
            }
        }
    }

    public void dispose() {
        this.image.dispose();
        this.gc.dispose();
    }
}

