/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c99.typeinfos;

import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.c99.C99DataValue;
import org.eclipse.escet.cif.codegen.c99.typeinfos.C99TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.BoolTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Strings;

public class C99BoolTypeInfo
extends BoolTypeInfo
implements C99TypeInfo {
    public final boolean genLocalFunctions;

    public C99BoolTypeInfo(boolean genLocalFunctions, CifType cifType) {
        super(cifType);
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return true;
    }

    @Override
    public boolean useValues() {
        return true;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return "BoolTypePrint";
    }

    @Override
    public ExprCode convertLiteral(boolean value, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeLiteral(value ? "TRUE" : "FALSE"));
        return result;
    }

    @Override
    public ExprCode convertInvert(Expression child, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(child, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeComputed(Strings.fmt((String)"!(%s)", (Object[])new Object[]{childCode.getData()})));
        return result;
    }

    @Override
    public ExprCode convertShortCircuit(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        switch (expr.getOperator()) {
            case IMPLICATION: {
                String pattern = "!(${left-value}) || (${right-value})";
                return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
            }
            case DISJUNCTION: {
                String pattern = "(${left-value}) || (${right-value})";
                return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
            }
            case CONJUNCTION: {
                String pattern = "(${left-value}) && (${right-value})";
                return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
            }
        }
        throw new RuntimeException("Unsupported short circuit operator: " + String.valueOf(expr.getOperator()));
    }

    @Override
    public String getTargetType() {
        return "BoolType";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "(${left-value}) == (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "(${left-value}) != (${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof C99BoolTypeInfo;
    }

    @Override
    public int hashCode() {
        return C99BoolTypeInfo.class.hashCode();
    }
}

