/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class CifLocationUtils {
    private CifLocationUtils() {
    }

    public static Automaton getAutomaton(Location loc) {
        return (Automaton)loc.eContainer();
    }

    public static String getName(Location loc) {
        String name = loc.getName();
        return name == null ? "*" : name;
    }

    public static Set<Location> getPossibleInitialLocs(Automaton aut) {
        return CifLocationUtils.getPossibleInitialLocs(aut, true);
    }

    public static Set<Location> getPossibleInitialLocs(Automaton aut, boolean checkRefs) {
        Set rslt = Sets.set();
        block0: for (Location loc : aut.getLocations()) {
            EList initials = loc.getInitials();
            if (initials.isEmpty()) continue;
            block1: for (Expression initial : initials) {
                if (!checkRefs) {
                    List refExprs = Lists.list();
                    CifScopeUtils.collectRefExprs(initial, refExprs);
                    for (Expression refExpr : refExprs) {
                        if (refExpr instanceof DiscVariableExpression || refExpr instanceof ContVariableExpression || refExpr instanceof AlgVariableExpression || refExpr instanceof LocationExpression || refExpr instanceof ComponentExpression || refExpr instanceof SelfExpression) continue block1;
                    }
                }
                if (CifValueUtils.isTriviallyFalse(initial, true, true)) continue block0;
            }
            rslt.add(loc);
        }
        return rslt;
    }

    public static List<Edge> getEdges(Location loc, Event evt) {
        List edges = Lists.list();
        for (Edge edge : loc.getEdges()) {
            if (evt == null && edge.getEvents().isEmpty()) {
                edges.add(edge);
                continue;
            }
            for (EdgeEvent edgeEvent : edge.getEvents()) {
                if (CifEventUtils.getEventFromEdgeEvent(edgeEvent) != evt) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    public static Set<Location> getNextLocations(Location loc, Event evt) {
        List<Edge> edges = CifLocationUtils.getEdges(loc, evt);
        Set nextLocs = Sets.setc((int)edges.size());
        for (Edge edge : edges) {
            nextLocs.add(edge.getTarget() == null ? loc : edge.getTarget());
        }
        return nextLocs;
    }

    public static Set<Location> getNextLocations(Set<Location> locs, Event evt) {
        Set nextLocs = Sets.set();
        for (Location loc : locs) {
            nextLocs.addAll(CifLocationUtils.getNextLocations(loc, evt));
        }
        return nextLocs;
    }
}

