/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input;

import java.util.List;
import org.eclipse.escet.cif.simulator.input.AutomaticInputComponent;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InputComponent;
import org.eclipse.escet.cif.simulator.options.HistoryOption;
import org.eclipse.escet.cif.simulator.options.HistorySizeOption;
import org.eclipse.escet.cif.simulator.options.InteractiveAutoChooseOption;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEvent;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.HistoryTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public abstract class InteractiveInputComponent<S extends RuntimeState>
extends InputComponent<S> {
    protected boolean autoSingle;
    protected boolean autoTime;
    protected boolean autoTimeDur;
    protected boolean[] autoEvents;
    protected AutomaticInputComponent<S> autoInput;
    protected final boolean isResetEnabled = HistoryOption.isEnabled();
    protected final boolean isUndoEnabled = HistorySizeOption.isUndoEnabled();

    public InteractiveInputComponent(RuntimeSpec<S> spec) {
        super(spec);
    }

    @Override
    public void init() {
        String[] filters = InteractiveAutoChooseOption.getFilters();
        this.autoSingle = InteractiveAutoChooseOption.autoChooseSingle(filters);
        this.autoTime = InteractiveAutoChooseOption.autoChooseTime(filters);
        this.autoTimeDur = InteractiveAutoChooseOption.autoChooseTimeDur(filters);
        this.autoEvents = InteractiveAutoChooseOption.autoChooseEvents(this.spec, filters);
        this.autoInput = this.needAutomaticInputComponent() ? new AutomaticInputComponent(this.spec) : null;
    }

    protected abstract boolean needAutomaticInputComponent();

    @Override
    public final Transition<S> chooseTransition(S state, List<Transition<S>> transitions, SimulationResult result) {
        if (transitions.isEmpty()) {
            if (!this.isResetEnabled && !this.isUndoEnabled) {
                throw new SimulatorExitException(result);
            }
            return this.chooseTransitionInteractive(state, result);
        }
        if (this.autoInput != null) {
            List autoTrans = Lists.listc((int)transitions.size());
            for (Transition<S> transition : transitions) {
                boolean isAuto;
                if (transition instanceof TimeTransition) {
                    isAuto = this.autoTime;
                } else {
                    RuntimeEvent event = ((EventTransition)transition).event;
                    isAuto = this.autoEvents[event.idx];
                }
                if (!isAuto) continue;
                autoTrans.add(transition);
            }
            if (autoTrans.size() == 1) {
                return (Transition)Lists.first((List)autoTrans);
            }
            if (autoTrans.size() > 1) {
                Assert.check((result == null ? 1 : 0) != 0);
                return this.autoInput.chooseTransition(state, autoTrans, result);
            }
        }
        if (this.autoSingle && transitions.size() == 1) {
            return (Transition)Lists.first(transitions);
        }
        return this.chooseTransitionInteractive(state, transitions);
    }

    protected abstract Transition<S> chooseTransitionInteractive(S var1, List<Transition<S>> var2);

    protected abstract HistoryTransition<S> chooseTransitionInteractive(S var1, SimulationResult var2);

    @Override
    public Double getNextMaxEndTime(S state) {
        if (this.autoTimeDur) {
            return this.autoInput.getNextMaxEndTime(state);
        }
        return null;
    }

    @Override
    public final ChosenTargetTime chooseTargetTime(S state, double maxTargetTime) {
        if (this.autoTimeDur) {
            return this.autoInput.chooseTargetTime(state, maxTargetTime);
        }
        return this.chooseTargetTimeInteractive(state, maxTargetTime);
    }

    protected abstract ChosenTargetTime chooseTargetTimeInteractive(S var1, double var2);
}

