/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.BusDetectionAlgorithm;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.output.BlackHoleOutputProvider;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class ClusterInput {
    public static final double DEFAULT_EVAPORATION = 2.0;
    public static final int DEFAULT_STEP_COUNT = 2;
    public static final double DEFAULT_INFLATION = 2.0;
    public static final double DEFAULT_CONVERGENCE_LIMIT = 1.0E-4;
    public static final BusDetectionAlgorithm DEFAULT_BUS_DETECTION = BusDetectionAlgorithm.NO_BUS;
    public static final double DEFAULT_BUS_FACTOR = 2.0;
    public final DebugNormalOutput debugOut;
    public final RealMatrix adjacencies;
    public final Label[] labels;
    public double evap;
    public int stepCount;
    public double inflation;
    public double epsilon;
    public BusDetectionAlgorithm busDetectionAlgorithm;
    public double busInclusion;

    public ClusterInput(RealMatrix adjacencies, Label[] labels, DebugNormalOutput debugOut) {
        this(adjacencies, labels, 2.0, 2, 2.0, 1.0E-4, DEFAULT_BUS_DETECTION, 2.0, debugOut);
    }

    public ClusterInput(RealMatrix adjacencies, Label[] labels, double evap, int stepCount, double inflation, double epsilon, BusDetectionAlgorithm busDetectionAlgorithm, double busInclusion, DebugNormalOutput debugOut) {
        this.adjacencies = adjacencies;
        this.labels = labels;
        this.evap = evap;
        this.stepCount = stepCount;
        this.inflation = inflation;
        this.epsilon = epsilon;
        this.busDetectionAlgorithm = busDetectionAlgorithm;
        this.setBusInclusionFactor(busInclusion);
        this.debugOut = debugOut != null ? debugOut : new BlackHoleOutputProvider().getDebugOutput();
    }

    public void setBusInclusionFactor(double newValue) {
        switch (this.busDetectionAlgorithm) {
            case NO_BUS: {
                this.busInclusion = newValue;
                break;
            }
            case FIX_POINT: {
                if (newValue >= 1.0 && newValue <= 4.0) {
                    this.busInclusion = newValue;
                    break;
                }
                String msg = Strings.fmt((String)"Bus factor values for the fixed-point algorithm are only allowed to be between 1.0 and 4.0 (including the boundaries). The supplied value of %f is outside this interval.", (Object[])new Object[]{newValue});
                throw new InvalidInputException(msg);
            }
            case TOP_K: {
                newValue = (int)newValue;
                if (newValue >= 0.0 && newValue <= (double)this.adjacencies.getRowDimension()) {
                    this.busInclusion = newValue;
                    break;
                }
                String msg = Strings.fmt((String)"Bus factor values for the top-k algorithm are only allowed to be between 0 and the number of elements of the DSM (which is %d in this case). The supplied value of %f is outside this interval.", (Object[])new Object[]{this.adjacencies.getRowDimension(), newValue});
                throw new InvalidInputException(msg);
            }
            default: {
                String msg = Strings.fmt((String)"Unsupported bus detection algorithm encountered: %s.", (Object[])new Object[]{this.busDetectionAlgorithm});
                throw new UnsupportedException(msg);
            }
        }
    }
}

