/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.xtext.naming.QualifiedName;

public class WorkspaceModelPath
implements IModelPath {
    private List<IContainer> paths;

    public WorkspaceModelPath(List<IContainer> paths) {
        this.paths = paths;
    }

    public Stream<IModelPath.ModelFile> getFiles(QualifiedName name) {
        QualifiedName pkgName = name.skipLast(1);
        String fileName = name.getLastSegment();
        return this.getPackage(pkgName).filter(mf -> mf.name.getLastSegment().equals(fileName));
    }

    public Stream<IModelPath.ModelFile> getAllFiles() {
        return this.paths.stream().filter(container -> container.isAccessible()).flatMap(container -> this.listAllFiles((IContainer)container, QualifiedName.EMPTY));
    }

    public Optional<QualifiedName> getQualifiedName(URI uri) {
        if (uri.isPlatform()) {
            Path path = new Path(uri.toPlatformString(true));
            return this.paths.stream().map(container -> container.getFullPath()).filter(arg_0 -> WorkspaceModelPath.lambda$4((IPath)path, arg_0)).map(arg_0 -> WorkspaceModelPath.lambda$5((IPath)path, arg_0)).map(p -> QualifiedName.create((String[])p.segments())).findFirst();
        }
        return Optional.empty();
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public List<IContainer> getPaths() {
        return this.paths;
    }

    public String toString() {
        return this.paths.toString();
    }

    private Stream<IModelPath.ModelFile> getPackage(QualifiedName name) {
        Path path = new Path(name.toString("/"));
        return this.paths.stream().map(container -> container.getFolder((IPath)path)).filter(folder -> folder.exists()).flatMap(folder -> this.listFiles((IContainer)folder, name));
    }

    private Stream<IModelPath.ModelFile> listFiles(IContainer container, QualifiedName name) {
        return this.getMembers(container).filter(resource -> resource.getType() == 1).map(file -> this.createModelFile((IFile)file, name));
    }

    private Stream<IModelPath.ModelFile> listAllFiles(IContainer container, QualifiedName name) {
        return this.getMembers(container).flatMap(resource -> {
            if (resource.getType() == 1) {
                return Stream.of(this.createModelFile((IFile)resource, name));
            }
            if (resource.getType() == 2) {
                IFolder subfolder = (IFolder)resource;
                return this.listAllFiles((IContainer)subfolder, name.append(subfolder.getName()));
            }
            return Stream.empty();
        });
    }

    private IModelPath.ModelFile createModelFile(IFile file, QualifiedName pkg) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        String fileName = file.getName();
        int periodIndex = fileName.lastIndexOf(46);
        if (periodIndex != -1) {
            String name = fileName.substring(0, periodIndex);
            String extension = fileName.substring(periodIndex + 1);
            return new IModelPath.ModelFile(uri, pkg.append(name), extension);
        }
        return new IModelPath.ModelFile(uri, pkg.append(fileName), "");
    }

    private Stream<IResource> getMembers(IContainer container) {
        try {
            return Stream.of(container.members());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$4(IPath iPath, IPath p) {
        return p.isPrefixOf(iPath);
    }

    private static /* synthetic */ IPath lambda$5(IPath iPath, IPath p) {
        return iPath.makeRelativeTo(p).removeFileExtension();
    }
}

