/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_qu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_MM = "Myanmar";
        final String metaValue_ar = "Arabe Simi";
        final String metaValue_bn = "Bangla Simi";
        final String metaValue_bo = "Tibetano Simi";
        final String metaValue_el = "Griego Simi";
        final String metaValue_gu = "Gujarati Simi";
        final String metaValue_he = "Hebreo Simi";
        final String metaValue_hy = "Armenio Simi";
        final String metaValue_ja = "Japones Simi";
        final String metaValue_kn = "Kannada Simi";
        final String metaValue_ko = "Coreano Simi";
        final String metaValue_lo = "Lao Simi";
        final String metaValue_ml = "Malayalam Simi";
        final String metaValue_mn = "Mongol Simi";
        final String metaValue_or = "Odia Simi";
        final String metaValue_si = "Cingales Simi";
        final String metaValue_ta = "Tamil Simi";
        final String metaValue_th = "Tailandes Simi";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu Simi" },
            { "ksh", "K\u00f6lsch Simi" },
            { "nyn", "Nyankole Simi" },
            { "luo", "Luo Simi" },
            { "Zsym", "Unanchakuna" },
            { "fil", "Filipino Simi" },
            { "hmn", "Hmong Daw Simi" },
            { "Zsye", "Emoji" },
            { "ccp", "Chakma Simi" },
            { "luy", "Luyia Simi" },
            { "bas", "Basaa Simi" },
            { "teo", "Teso Simi" },
            { "AC", "Islas Ascensi\u00f3n" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Unidos" },
            { "nl_BE", "Flamenco Simi" },
            { "AF", "Afganist\u00e1n" },
            { "af", "Afrikaans Simi" },
            { "AG", "Antigua y Barbuda" },
            { "type.ca.ethiopic", "Etiope Intiwatana" },
            { "AI", "Anguila" },
            { "ak", "Akan Simi" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "Amarico Simi" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Ant\u00e1rtida" },
            { "ar", metaValue_ar },
            { "AR", "Argentina" },
            { "Hrkt", "Japones silabico sananpakuna" },
            { "AS", "Samoa Americana" },
            { "as", "Asames Simi" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islas \u00c5land" },
            { "ay", "Aymara Simi" },
            { "AZ", "Azerbaiy\u00e1n" },
            { "az", "Azerbaiyano Simi" },
            { "BA", "Bosnia y Herzegovina" },
            { "ba", "Baskir Simi" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano Simi" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e9lgica" },
            { "be", "Bielorruso Simi" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "Bulgaro Simi" },
            { "BH", "Bar\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Bermudas" },
            { "bm", "Bambara Simi" },
            { "bn", metaValue_bn },
            { "BN", "Brun\u00e9i" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Bonaire" },
            { "BR", "Brasil" },
            { "br", "Breton Simi" },
            { "BS", "Bahamas" },
            { "bs", "Bosnio Simi" },
            { "xog", "Soga Simi" },
            { "BT", "But\u00e1n" },
            { "BV", "Isla Bouvet" },
            { "Mymr", metaValue_MM },
            { "BW", "Botsuana" },
            { "type.nu.laoo", "Lao Sananpakuna" },
            { "BY", "Belar\u00fas" },
            { "seh", "Sena Simi" },
            { "BZ", "Belice" },
            { "type.ca.persian", "Persa Intiwatana" },
            { "type.nu.hebr", "Hebreo Yupaykuna" },
            { "CA", "Canad\u00e1" },
            { "ca", "Catalan Simi" },
            { "CC", "Islas Cocos" },
            { "mzn", "Mazandaran\u00ed Simi" },
            { "ses", "Koyraboro Senni Simi" },
            { "CD", "Congo (RDC)" },
            { "ce", "Checheno Simi" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congo" },
            { "CH", "Suiza" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "Corso Simi" },
            { "CP", "Isla Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "Checo Simi" },
            { "CU", "Cuba" },
            { "cu", "Eslavo Eclesi\u00e1stico Simi" },
            { "CV", "Cabo Verde" },
            { "CW", "Curazao" },
            { "CX", "Isla Christmas" },
            { "CY", "Chipre" },
            { "cy", "Gales Simi" },
            { "CZ", "Chequia" },
            { "type.nu.ethi", "Etiope Sananpakuna" },
            { "da", "Danes Simi" },
            { "DE", "Alemania" },
            { "de", "Aleman Simi" },
            { "cgg", "Kiga Simi" },
            { "DG", "Diego Garc\u00eda" },
            { "type.cf.standard", "Estandar nisqa qullqi imayna kaynin" },
            { "type.nu.deva", "Devanagari Sananpakuna" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "Brai", "Braile" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armenio Uchuy Sananpakuna" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "bem", "Bemba Simi" },
            { "dv", "Divehi Simi" },
            { "es_419", "Espa\u00f1ol Simi (Latino Am\u00e9rica)" },
            { "DZ", "Argelia" },
            { "dz", "Butan\u00e9s Simi" },
            { "bez", "Bena Simi" },
            { "type.ca.chinese", "Chino Intiwatana" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma Simi" },
            { "pap", "Papiamento Simi" },
            { "type.nu.grek", "Griego Yupaykuna" },
            { "EE", "Estonia" },
            { "ee", "Ew\u00e9 Simi" },
            { "type.lb.normal", "Siqi paway Normal kaynin" },
            { "EG", "Egipto" },
            { "EH", "Sahara Occidental" },
            { "el", metaValue_el },
            { "en", "Ingles Simi" },
            { "eo", "Esperanto Simi" },
            { "chr", "Cheroqui Simi" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "es", "Espa\u00f1ol Simi" },
            { "ET", "Etiop\u00eda" },
            { "et", "Estonio Simi" },
            { "Hanb", "Han with Bopomofo" },
            { "EU", "Union Europea" },
            { "eu", "Euskera Simi" },
            { "Hang", "Hangul" },
            { "type.ca.gregorian", "Gregoriano Intiwatana" },
            { "EZ", "Eurozona" },
            { "shi", "Tashelhit Simi" },
            { "type.nu.gujr", "Gujarati Sananpakuna" },
            { "hsb", "Alto Sorbio Simi" },
            { "Hani", "Han" },
            { "fa", "Persa Simi" },
            { "Hans", "Simplificado" },
            { "type.nu.latn", "Occidental Sananpakuna" },
            { "Hant", "Tradicional" },
            { "ff", "Fulah Simi" },
            { "FI", "Finlandia" },
            { "fi", "Fines Simi" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "yue", "Canton\u00e9s Simi" },
            { "FO", "Islas Feroe" },
            { "fo", "Feroes Simi" },
            { "Taml", metaValue_ta },
            { "FR", "Francia" },
            { "fr", "Frances Simi" },
            { "fy", "Frison Simi" },
            { "GA", "Gab\u00f3n" },
            { "ga", "Irlandes Simi" },
            { "GB", "Reino Unido" },
            { "pcm", "Pidgin Nigeriano Simi" },
            { "GD", "Granada" },
            { "gd", "Gaelico Escoces Simi" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "gl", "Gallego Simi" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "und", "Mana Riqsisqa Simi" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sur e Islas Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "Man\u00e9s Simi" },
            { "GW", "Guinea-Bis\u00e1u" },
            { "rhg", "Rohingya Simi" },
            { "GY", "Guyana" },
            { "ha", "Hausa Simi" },
            { "ckb", "Chawpi Kurdo Simi" },
            { "zxx", "Manaraq simi yachana" },
            { "he", metaValue_he },
            { "hi", "Hindi Simi" },
            { "HK", "Hong Kong RAE China" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "hr", "Croata Simi" },
            { "agq", "Aghem Simi" },
            { "gsw", "Alsaciano Simi" },
            { "HT", "Hait\u00ed" },
            { "ht", "Haitiano Criollo Simi" },
            { "HU", "Hungr\u00eda" },
            { "hu", "Hungaro Simi" },
            { "hy", metaValue_hy },
            { "ia", "Interlingua Simi" },
            { "IC", "Islas Canarias" },
            { "Jamo", "Jamo" },
            { "ID", "Indonesia" },
            { "id", "Indonesio Simi" },
            { "type.nu.tibt", "Tibetano Sananpakuna" },
            { "IE", "Irlanda" },
            { "ig", "Igbo Simi" },
            { "naq", "Nama Simi" },
            { "ii", "Yi Simi" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "IO", "Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico" },
            { "IQ", "Irak" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "is", "Islandes Simi" },
            { "IT", "Italia" },
            { "it", "Italiano Simi" },
            { "iu", "Inuktitut Simi" },
            { "Zmth", "Matimatica Willay" },
            { "type.nu.thai", "Thai Sananpakuna" },
            { "type.nu.beng", "Bangla Sananpakuna" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamico Intiwatana" },
            { "doi", "Dogri Simi" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Jap\u00f3n" },
            { "sma", "Qulla Sami Simi" },
            { "jv", "Javan\u00e9s Simi" },
            { "guz", "Guz\u00ed Simi" },
            { "type.nu.knda", "Kannada Sananpakuna" },
            { "smj", "Sami Lule Simi" },
            { "mai", "Maithili Simi" },
            { "smn", "Sami Inari Simi" },
            { "ka", "Georgiano Simi" },
            { "type.ca.buddhist", "Budista Intiwatana" },
            { "sms", "Sami Skolt Simi" },
            { "KE", "Kenia" },
            { "419", "AmericaLatina" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "ki", "Kikuyu Simi" },
            { "mas", "Masai Simi" },
            { "kk", "Kazajo Simi" },
            { "kl", "Groenlandes Simi" },
            { "KM", "Comoras" },
            { "km", "Khmer Simi" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "San Crist\u00f3bal y Nieves" },
            { "ko", metaValue_ko },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "ks", "Cachemir Simi" },
            { "ku", "Kurdo Simi" },
            { "KW", "Kuwait" },
            { "kw", "C\u00f3rnico Simi" },
            { "KY", "Islas Caim\u00e1n" },
            { "ky", "Kirghiz Simi" },
            { "KZ", "Kazajist\u00e1n" },
            { "Cyrl", "Cirilico" },
            { "LA", "Laos" },
            { "la", "Lat\u00edn Simi" },
            { "LB", "L\u00edbano" },
            { "lb", "Luxemburgues Simi" },
            { "LC", "Santa Lucia" },
            { "type.nu.mlym", "Malayalam Sananpakuna" },
            { "lg", "Luganda Simi" },
            { "nds", "Bajo Alem\u00e1n Simi" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala Simi" },
            { "fur", "Friulano Simi" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Metrico Ingles Kamay" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "lt", "Lituano Simi" },
            { "LU", "Luxemburgo" },
            { "lu", "Luba-Katanga Simi" },
            { "LV", "Letonia" },
            { "lv", "Leton Simi" },
            { "Kana", "Katakana" },
            { "LY", "Libia" },
            { "vun", "Vunjo Simi" },
            { "lag", "Langi Simi" },
            { "Thaa", "Thaana Simi" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "San Mart\u00edn" },
            { "MG", "Madagascar" },
            { "mg", "Malgache Simi" },
            { "Thai", metaValue_th },
            { "MH", "Islas Marshall" },
            { "type.co.ducet", "\u00d1awpaqchasqa Unicode Nisqa \u00d1iqinchana" },
            { "mi", "Maori Simi" },
            { "MK", "Macedonia del Norte" },
            { "mk", "Macedonio Simi" },
            { "ml", metaValue_ml },
            { "ML", "Mal\u00ed" },
            { "MM", metaValue_MM },
            { "mn", metaValue_mn },
            { "MN", "Mongolia" },
            { "MO", "Macao RAE China" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "mr", "Marathi Simi" },
            { "MS", "Montserrat" },
            { "ms", "Malayo Simi" },
            { "MT", "Malta" },
            { "mt", "Maltes Simi" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e9xico" },
            { "type.ca.japanese", "Japones Intiwatana" },
            { "MY", "Malasia" },
            { "my", "Birmano Simi" },
            { "Armn", metaValue_hy },
            { "MZ", "Mozambique" },
            { "dsb", "Bajo Sorbio Simi" },
            { "NA", "Namibia" },
            { "type.co.search", "Llapanpaq maskana" },
            { "202", "Africa Sub-Sahariana" },
            { "nb", "Noruego Bokm\u00e5l Simi" },
            { "type.ca.hebrew", "Hebreo Intiwatana" },
            { "NC", "Nueva Caledonia" },
            { "nd", "Ndebele septentrional Simi" },
            { "NE", "N\u00edger" },
            { "ne", "Nepali Simi" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Bajos" },
            { "nl", "Neerlandes Simi" },
            { "nn", "Noruego Nynorsk Simi" },
            { "NO", "Noruega" },
            { "no", "Noruego Simi" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo Simi" },
            { "ny", "Nyanja Simi" },
            { "NZ", "Nueva Zelanda" },
            { "kab", "Cabilio Simi" },
            { "oc", "Occitano Simi" },
            { "kam", "Kamba Simi" },
            { "mer", "Meru Simi" },
            { "type.nu.armn", "Armenio Sananpakuna" },
            { "OM", "Om\u00e1n" },
            { "om", "Oromo Simi" },
            { "or", metaValue_or },
            { "os", "Osetio Simi" },
            { "mfe", "Mauriciano Simi" },
            { "PA", "Panam\u00e1" },
            { "pa", "Punyabi Simi" },
            { "dua", "Duala Simi" },
            { "PE", "Per\u00fa" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakist\u00e1n" },
            { "PL", "Polonia" },
            { "pl", "Polaco Simi" },
            { "ewo", "Ewondo Simi" },
            { "PM", "San Pedro y Miquel\u00f3n" },
            { "PN", "Islas Pitcairn" },
            { "type.ca.dangi", "Dangi Intiwatana" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestina Kamachikuq" },
            { "ps", "Pashto Simi" },
            { "PT", "Portugal" },
            { "pt", "Portugues Simi" },
            { "key.co", "\u00d1iqinchana" },
            { "PW", "Palaos" },
            { "type.nu.greklow", "Griego Uchuy Yupaykuna" },
            { "PY", "Paraguay" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto Simi" },
            { "key.cf", "Imayna Qullqi kaynin" },
            { "QA", "Qatar" },
            { "key.ca", "Intiwatana" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u02bc Simi" },
            { "type.hc.h23", "24 hora kaynin (0\u201323)" },
            { "type.hc.h24", "24 hora kaynin (1\u201324)" },
            { "type.nu.mymr", "Myanmar Sananpakuna" },
            { "QO", "Ocean\u00eda Perif\u00e9rica" },
            { "qu", "Runasimi" },
            { "brx", "Bodo Simi" },
            { "kde", "Makonde Simi" },
            { "001", "Pacha" },
            { "Ethi", "Etiope" },
            { "002", "Africa" },
            { "003", "Norte America" },
            { "RE", "Reuni\u00f3n" },
            { "type.hc.h12", "12 hora kaynin (1\u201312)" },
            { "005", "Sud America" },
            { "type.hc.h11", "12 hora kaynin (0\u201311)" },
            { "009", "Oceania" },
            { "rm", "Romanche Simi" },
            { "rn", "Rundi Simi" },
            { "key.cu", "qullqi" },
            { "RO", "Rumania" },
            { "ro", "Rumano Simi" },
            { "RS", "Serbia" },
            { "type.nu.orya", "Odia Sananpakuna" },
            { "type.nu.hanidec", "Chunkachasqa Chino Yupaykuna" },
            { "RU", "Rusia" },
            { "ru", "Ruso Simi" },
            { "RW", "Ruanda" },
            { "rw", "Kinyarwanda Simi" },
            { "kea", "Caboverdiano Simi" },
            { "SA", "Arabia Saud\u00ed" },
            { "sa", "Sanscrito Simi" },
            { "SB", "Islas Salom\u00f3n" },
            { "twq", "Tasawaq Simi" },
            { "011", "Africa Occidental" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e1n" },
            { "sd", "Sindhi Simi" },
            { "013", "America Central" },
            { "SE", "Suecia" },
            { "se", "Chincha Sami Simi" },
            { "014", "Africa Oriental" },
            { "015", "Africa del Norte" },
            { "SG", "Singapur" },
            { "sg", "Sango Simi" },
            { "SH", "Santa Elena" },
            { "type.lb.strict", "Siqi paway Chiqa kaynin" },
            { "si", metaValue_si },
            { "017", "Africa Media" },
            { "SI", "Eslovenia" },
            { "018", "Sud Africa" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "019", "America" },
            { "SK", "Eslovaquia" },
            { "sk", "Eslovaco Simi" },
            { "SL", "Sierra Leona" },
            { "sl", "Esloveno Simi" },
            { "SM", "San Marino" },
            { "sm", "Samoano Simi" },
            { "SN", "Senegal" },
            { "sn", "Shona Simi" },
            { "SO", "Somalia" },
            { "so", "Somali Simi" },
            { "arn", "Mapuche Simi" },
            { "type.nu.arab", "Arabe Sananpakuna" },
            { "sq", "Albanes Simi" },
            { "type.nu.taml", "Kikin Tamil Yupaykuna" },
            { "SR", "Surinam" },
            { "sr", "Serbio Simi" },
            { "SS", "Sud\u00e1n del Sur" },
            { "type.cf.account", "Yupana Qullqi imayna kaynin" },
            { "ST", "Santo Tom\u00e9 y Pr\u00edncipe" },
            { "st", "Soto Meridional Simi" },
            { "su", "Sundan\u00e9s Simi" },
            { "SV", "El Salvador" },
            { "sv", "Sueco Simi" },
            { "sw", "Suajili Simi" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "type.nu.hantfin", "Kikin Qullqi Chino Yupaypakuna" },
            { "SZ", "Suazilandia" },
            { "ta", metaValue_ta },
            { "TA", "Trist\u00e1n de Acu\u00f1a" },
            { "asa", "Asu Simi" },
            { "type.ms.ussystem", "Metrico Americano Kamay" },
            { "021", "America del Norte" },
            { "142", "Asia" },
            { "TC", "Islas Turcas y Caicos" },
            { "yav", "Yangben Simi" },
            { "143", "Asia Central" },
            { "TD", "Chad" },
            { "te", "Telugu Simi" },
            { "145", "Asia Occidental" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "tg", "Tayiko Simi" },
            { "th", metaValue_th },
            { "TH", "Tailandia" },
            { "ti", "Tigri\u00f1a Simi" },
            { "TJ", "Tayikist\u00e1n" },
            { "029", "Caribe" },
            { "TK", "Tokelau" },
            { "tk", "Turcomano Simi" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "T\u00fanez" },
            { "tn", "Setsuana Simi" },
            { "TO", "Tonga" },
            { "to", "Tongano Simi" },
            { "dyo", "Jola-Fonyi Simi" },
            { "type.nu.jpan", "Japones Yupaykuna" },
            { "TR", "Turqu\u00eda" },
            { "tr", "Turco Simi" },
            { "TT", "Trinidad y Tobago" },
            { "tt", "Tartaro Simi" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "ast", "Asturiano Simi" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio Ngumba Simi" },
            { "Zzzz", "Mana yachasqa Qillqa" },
            { "150", "Europa" },
            { "UA", "Ucrania" },
            { "030", "Asia Oriental" },
            { "151", "Europa Oriental" },
            { "154", "Europa del Norte" },
            { "sw_CD", "Suajili Simi (Congo (RDC))" },
            { "034", "Asia del Sur" },
            { "155", "Europa Occidental" },
            { "035", "Sureste de Asia" },
            { "UG", "Uganda" },
            { "ug", "Uigur Simi" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Common Simi" },
            { "039", "Europa del Sur" },
            { "uk", "Ucraniano Simi" },
            { "Sinh", metaValue_si },
            { "UM", "Islas menores alejadas de los EE.UU." },
            { "UN", "Naciones Unidas" },
            { "ur", "Urdu Simi" },
            { "US", "Estados Unidos" },
            { "haw", "Hawaiano Simi" },
            { "UY", "Uruguay" },
            { "prg", "Prusiano Simi" },
            { "UZ", "Uzbekist\u00e1n" },
            { "uz", "Uzbeko Simi" },
            { "tzm", "Tamazight Simi" },
            { "nnh", "Ngiemboon Simi" },
            { "VA", "Santa Sede (Ciudad del Vaticano)" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "type.ca.roc", "Minguo Intiwatana" },
            { "VG", "Islas V\u00edrgenes Brit\u00e1nicas" },
            { "VI", "EE.UU. Islas V\u00edrgenes" },
            { "vi", "Vietnamita Simi" },
            { "khq", "Koyra Chiini Simi" },
            { "key.hc", "Ciclo de Horas (12 vs 24)" },
            { "VN", "Vietnam" },
            { "vo", "Volap\u00fck Simi" },
            { "quc", "K\u02bciche\u02bc Simi" },
            { "VU", "Vanuatu" },
            { "rwk", "Rwa Simi" },
            { "syr", "Siriaco Simi" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis y Futuna" },
            { "Grek", metaValue_el },
            { "057", "Regi\u00f3n Micronesia" },
            { "jgo", "Ngomba Simi" },
            { "lkt", "Lakota Simi" },
            { "wo", "Wolof Simi" },
            { "wae", "Walser Simi" },
            { "zgh", "Bereber Marroqu\u00ed Est\u00e1ndar Simi" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "XA", "Seudo-Acentos" },
            { "mni", "Manipuri Simi" },
            { "XB", "Seudo-Bidi" },
            { "061", "Polinesia" },
            { "Latn", "Latin Simi" },
            { "type.nu.hans", "Uchuyachusqa Chino Yupaypakuna" },
            { "type.nu.hant", "Kikin Chino Yupaypakuna" },
            { "xh", "Isixhosa Simi" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "Roman Uchuy Yupaykuna" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Mana qillqasqa" },
            { "moh", "Mohawk Simi" },
            { "kkj", "Kako Simi" },
            { "YE", "Yemen" },
            { "type.co.standard", "Estandar nisqa \u00d1iqinchana" },
            { "yi", "Yiddish Simi" },
            { "yo", "Yoruba Simi" },
            { "YT", "Mayotte" },
            { "vai", "Vai Simi" },
            { "ZA", "Sud\u00e1frica" },
            { "type.lb.loose", "Siqi paway chinkachiy kaynin" },
            { "kln", "Kalenjin Simi" },
            { "Deva", "Devanagari" },
            { "zh", "Chino Simi" },
            { "type.nu.geor", "Gregoriano Yupaykuna" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Bopomofo Simi" },
            { "key.lb", "Siqi paway kaynin" },
            { "zu", "Isizulu Simi" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Mana yachasqa Suyu" },
            { "Geor", "Georgiano" },
            { "type.ms.metric", "Metrico Kamay" },
            { "type.ca.iso8601", "ISO-8601 Intiwatana" },
            { "nso", "Sesotho Sa Leboa Simi" },
            { "type.nu.telu", "Telegu Sananpakuna" },
            { "type.nu.jpanfin", "Japones Qullqi Yupaykuna" },
            { "ebu", "Embu Simi" },
            { "jmc", "Machame Simi" },
            { "zh_Hans", "Chino Simplificado Simi" },
            { "type.nu.hansfin", "Uchuyachisqa Qullqi Chino Yupaypakuna" },
            { "kok", "Konkani Simi" },
            { "type.nu.arabext", "Arabe Mirachisqa Sananpakuna" },
            { "nus", "Nuer Simi" },
            { "type.nu.fullwide", "Llapan kinray Sananpakuna" },
            { "dav", "Taita Simi" },
            { "lrc", "Luri septentrional Simi" },
            { "zh_Hant", "Chino Tradicional Simi" },
            { "type.nu.khmr", "Khmer Sananpakuna" },
            { "mua", "Mundang Simi" },
            { "type.nu.guru", "Gurmukhi Sananpakuna" },
            { "Khmr", "Khmer" },
            { "mul", "Idiomas M\u00b4\u00faltiples Simi" },
            { "key.ms", "Tupuy Kamay" },
            { "type.nu.roman", "Romano Sananpakuna" },
            { "sah", "Sakha Simi" },
            { "type.nu.tamldec", "Tamil Sananpakuna" },
            { "saq", "Samburu Simi" },
            { "fa_AF", "Dari Simi" },
            { "sat", "Santali Simi" },
            { "key.nu", "Yupaykuna" },
            { "Guru", "Gurmukhi Simi" },
            { "ksb", "Shambala Simi" },
            { "Telu", "Tegulu Simi" },
            { "ksf", "Bafia Simi" },
        };
        return data;
    }
}
