/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.internal.jimage.ImageReader;
import jdk.internal.jrtfs.SystemImage;

class ExplodedImage
extends SystemImage {
    private static final String MODULES = "/modules/";
    private static final String PACKAGES = "/packages/";
    private final Path modulesDir;
    private final String separator;
    private final Map<String, PathNode> nodes = new HashMap<String, PathNode>();
    private final BasicFileAttributes modulesDirAttrs;

    ExplodedImage(Path modulesDir) throws IOException {
        this.modulesDir = modulesDir;
        String str = modulesDir.getFileSystem().getSeparator();
        this.separator = str.equals("/") ? null : str;
        this.modulesDirAttrs = Files.readAttributes(modulesDir, BasicFileAttributes.class, new LinkOption[0]);
        this.initNodes();
    }

    @Override
    public synchronized void close() throws IOException {
        this.nodes.clear();
    }

    @Override
    public byte[] getResource(ImageReader.Node node) throws IOException {
        return ((PathNode)node).getContent();
    }

    @Override
    public synchronized ImageReader.Node findNode(String name) {
        PathNode node = this.nodes.get(name);
        if (node != null) {
            return node;
        }
        Path path = this.underlyingModulesPath(name);
        if (path == null) {
            return null;
        }
        return this.createModulesNode(name, path);
    }

    private ImageReader.Node createModulesNode(String name, Path path) {
        assert (!this.nodes.containsKey(name)) : "Node must not already exist: " + name;
        assert (ExplodedImage.isNonEmptyModulesPath(name)) : "Invalid modules name: " + name;
        try {
            Path f;
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (attrs.isRegularFile() ? (f = path.getFileName()).toString().startsWith("_the.") : !attrs.isDirectory()) {
                return null;
            }
            PathNode node = new PathNode(name, path, attrs);
            this.nodes.put(name, node);
            return node;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    private Path underlyingModulesPath(String name) {
        if (ExplodedImage.isNonEmptyModulesPath(name)) {
            Path path = this.modulesDir.resolve(this.frontSlashToNativeSlash(name.substring(MODULES.length())));
            return Files.exists(path, new LinkOption[0]) ? path : null;
        }
        return null;
    }

    private static boolean isNonEmptyModulesPath(String name) {
        return name.startsWith(MODULES) && name.length() > MODULES.length();
    }

    private String frontSlashToNativeSlash(String str) {
        return this.separator == null ? str : str.replace("/", this.separator);
    }

    private String nativeSlashToFrontSlash(String str) {
        return this.separator == null ? str : str.replace(this.separator, "/");
    }

    private String slashesToDots(String str) {
        return str.replace(this.separator != null ? this.separator : "/", ".");
    }

    private void initNodes() throws IOException {
        HashMap packageToModules = new HashMap();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.modulesDir);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                String string = path.getFileName().toString();
                Objects.requireNonNull(this.createModulesNode(MODULES + string, path));
                Stream<Path> contentsStream = Files.walk(path, new FileVisitOption[0]);
                try {
                    contentsStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(p -> {
                        String pkgName = this.slashesToDots((p = path.relativize((Path)p)).toString());
                        if (!pkgName.isEmpty() && !pkgName.startsWith("META-INF")) {
                            packageToModules.computeIfAbsent(pkgName, k -> new ArrayList()).add(string);
                        }
                    });
                }
                finally {
                    if (contentsStream == null) continue;
                    contentsStream.close();
                }
            }
        }
        PathNode modulesRootNode = new PathNode("/modules", new ArrayList<PathNode>(this.nodes.values()));
        this.nodes.put(modulesRootNode.getName(), modulesRootNode);
        ArrayList<PathNode> packagesChildren = new ArrayList<PathNode>(packageToModules.size());
        for (Map.Entry entry : packageToModules.entrySet()) {
            String pkgName = (String)entry.getKey();
            List moduleNameList = (List)entry.getValue();
            ArrayList<PathNode> moduleLinkNodes = new ArrayList<PathNode>(moduleNameList.size());
            for (String moduleName : moduleNameList) {
                ImageReader.Node moduleNode = Objects.requireNonNull(this.nodes.get(MODULES + moduleName));
                PathNode linkNode = new PathNode(PACKAGES + pkgName + "/" + moduleName, moduleNode);
                this.nodes.put(linkNode.getName(), linkNode);
                moduleLinkNodes.add(linkNode);
            }
            PathNode pkgDir = new PathNode(PACKAGES + pkgName, moduleLinkNodes);
            this.nodes.put(pkgDir.getName(), pkgDir);
            packagesChildren.add(pkgDir);
        }
        PathNode pathNode = new PathNode("/packages", packagesChildren);
        this.nodes.put(pathNode.getName(), pathNode);
        ArrayList<PathNode> arrayList = new ArrayList<PathNode>();
        arrayList.add(pathNode);
        arrayList.add(modulesRootNode);
        PathNode root = new PathNode("/", arrayList);
        this.nodes.put(root.getName(), root);
    }

    private final class PathNode
    extends ImageReader.Node {
        private Path path;
        private PathNode link;
        private List<ImageReader.Node> children;

        private PathNode(String name, Path path, BasicFileAttributes attrs) {
            super(name, attrs);
            this.path = path;
        }

        private PathNode(String name, ImageReader.Node link) {
            super(name, link.getFileAttributes());
            this.link = (PathNode)link;
        }

        private PathNode(String name, List<ImageReader.Node> children) {
            super(name, ExplodedImage.this.modulesDirAttrs);
            this.children = children;
        }

        @Override
        public boolean isResource() {
            return this.link == null && !this.getFileAttributes().isDirectory();
        }

        @Override
        public boolean isDirectory() {
            return this.children != null || this.link == null && this.getFileAttributes().isDirectory();
        }

        @Override
        public boolean isLink() {
            return this.link != null;
        }

        @Override
        public PathNode resolveLink(boolean recursive) {
            if (this.link == null) {
                return this;
            }
            return recursive && this.link.isLink() ? this.link.resolveLink(true) : this.link;
        }

        private byte[] getContent() throws IOException {
            if (!this.getFileAttributes().isRegularFile()) {
                throw new FileSystemException(this.getName() + " is not file");
            }
            return Files.readAllBytes(this.path);
        }

        @Override
        public Stream<String> getChildNames() {
            if (!this.isDirectory()) {
                throw new IllegalArgumentException("not a directory: " + this.getName());
            }
            if (this.children == null) {
                ArrayList<ImageReader.Node> list = new ArrayList<ImageReader.Node>();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
                    for (Path p : stream) {
                        p = ExplodedImage.this.modulesDir.relativize(p);
                        String pName = ExplodedImage.MODULES + ExplodedImage.this.nativeSlashToFrontSlash(p.toString());
                        ImageReader.Node node = ExplodedImage.this.findNode(pName);
                        if (node == null) continue;
                        list.add(node);
                    }
                }
                catch (IOException x) {
                    return null;
                }
                this.children = list;
            }
            return this.children.stream().map(ImageReader.Node::getName);
        }

        @Override
        public long size() {
            try {
                return this.isDirectory() ? 0L : Files.size(this.path);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }
}

