/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean tíð",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia vanlig tíð",
               "",
               "Apia summartíð",
               "",
               "Apia tíð",
               "",
            };
        final String[] Cook = new String[] {
               "Cooksoyggjar vanlig tíð",
               "",
               "Cooksoyggjar summartíð",
               "",
               "Cooksoyggjar tíð",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba vanlig tíð",
               "CST",
               "Cuba summartíð",
               "CDT",
               "Cuba tíð",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji vanlig tíð",
               "",
               "Fiji summartíð",
               "",
               "Fiji tíð",
               "",
            };
        final String[] Gulf = new String[] {
               "Gulf vanlig tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd vanlig tíð",
               "",
               "Hovd summartíð",
               "",
               "Hovd tíð",
               "",
            };
        final String[] Iran = new String[] {
               "Iran vanlig tíð",
               "",
               "Iran summartíð",
               "",
               "Iran tíð",
               "",
            };
        final String[] Niue = new String[] {
               "Niue tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk vanlig tíð",
               "",
               "Omsk summartíð",
               "",
               "Omsk tíð",
               "",
            };
        final String[] Peru = new String[] {
               "Peru vanlig tíð",
               "",
               "Peru summartíð",
               "",
               "Peru tíð",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wakeoyggj tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Kili vanlig tíð",
               "",
               "Kili summartíð",
               "",
               "Kili tíð",
               "",
            };
        final String[] China = new String[] {
               "Kina vanlig tíð",
               "CST",
               "Kina summartíð",
               "CDT",
               "Kina tíð",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India tíð",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan vanlig tíð",
               "JST",
               "Japan summartíð",
               "JDT",
               "Japan tíð",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea vanlig tíð",
               "KST",
               "Korea summartíð",
               "KST",
               "Korea tíð",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa vanlig tíð",
               "SST",
               "Samoa summartíð",
               "SST",
               "Samoa tíð",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga vanlig tíð",
               "",
               "Tonga summartíð",
               "",
               "Tonga tíð",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukon tíð",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska vanlig tíð",
               "AKST",
               "Alaska summartíð",
               "AKDT",
               "Alaska tíð",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amasona vanlig tíð",
               "",
               "Amasona summartíð",
               "",
               "Amasona tíð",
               "",
            };
        final String[] Azores = new String[] {
               "Azorurnar vanlig tíð",
               "",
               "Azorurnar summartíð",
               "",
               "Azorurnar tíð",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Páskaoyggin vanlig tíð",
               "",
               "Páskaoyggin summartíð",
               "",
               "Páskaoyggin tíð",
               "",
            };
        final String[] Guyana = new String[] {
               "Gujana tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ísrael vanlig tíð",
               "IST",
               "Ísrael summartíð",
               "IDT",
               "Ísrael tíð",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva vanlig tíð",
               "MSK",
               "Moskva summartíð",
               "MSK",
               "Moskva tíð",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei vanlig tíð",
               "CST",
               "Taipei summartíð",
               "CDT",
               "Taipei tíð",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis- og Futunaoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabisk vanlig tíð",
               "",
               "Arabisk summartíð",
               "",
               "Arabisk tíð",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia vanlig tíð",
               "",
               "Armenia summartíð",
               "",
               "Armenia tíð",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham vanlig tíð",
               "",
               "Chatham summartíð",
               "",
               "Chatham tíð",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Samskipað heimstíð",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia vanlig tíð",
               "",
               "Georgia summartíð",
               "",
               "Georgia tíð",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk vanlig tíð",
               "",
               "Irkutsk summartíð",
               "",
               "Irkutsk tíð",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan vanlig tíð",
               "",
               "Magadan summartíð",
               "",
               "Magadan tíð",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar (Burma) tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkoyggj vanlig tíð",
               "",
               "Norfolkoyggj summartíð",
               "",
               "Norfolkoyggj tíð",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha vanlig tíð",
               "",
               "Fernando de Noronha summartíð",
               "",
               "Fernando de Noronha tíð",
               "",
            };
        final String[] Reunion = new String[] {
               "Réunion tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguai vanlig tíð",
               "",
               "Uruguai summartíð",
               "",
               "Uruguai tíð",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu vanlig tíð",
               "",
               "Vanuatu summartíð",
               "",
               "Vanuatu tíð",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk vanlig tíð",
               "",
               "Yakutsk summartíð",
               "",
               "Yakutsk tíð",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic vanlig tíð",
               "AST",
               "Atlantic summartíð",
               "AST",
               "Atlantic tíð",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia vanlig tíð",
               "",
               "Brasilia summartíð",
               "",
               "Brasilia tíð",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro vanlig tíð",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolombia vanlig tíð",
               "",
               "Kolombia summartíð",
               "",
               "Kolombia tíð",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsoyggjar vanlig tíð",
               "",
               "Falklandsoyggjar summartíð",
               "",
               "Falklandsoyggjar tíð",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaisia tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator vanlig tíð",
               "",
               "Ulan Bator summartíð",
               "",
               "Ulan Bator tíð",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan vanlig tíð",
               "PKT",
               "Pakistan summartíð",
               "PKST",
               "Pakistan tíð",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguai vanlig tíð",
               "",
               "Paraguai summartíð",
               "",
               "Paraguai tíð",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin vanlig tíð",
               "",
               "Sakhalin summartíð",
               "",
               "Sakhalin tíð",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina vanlig tíð",
               "",
               "Argentina summartíð",
               "",
               "Argentina tíð",
               "",
            };
        final String[] Christmas = new String[] {
               "Jólaoyggj tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong vanlig tíð",
               "HKT",
               "Hong Kong summartíð",
               "HKST",
               "Hong Kong tíð",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokina tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisia tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe vanlig tíð",
               "",
               "Lord Howe summartíð",
               "",
               "Lord Howe tíð",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Móritius vanlig tíð",
               "",
               "Móritius summartíð",
               "",
               "Móritius tíð",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapor tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venesuela tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd vanlig tíð",
               "MSK",
               "Volgograd summartíð",
               "MSK",
               "Volgograd tíð",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbadjan vanlig tíð",
               "",
               "Aserbadjan summartíð",
               "",
               "Aserbadjan tíð",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesj vanlig tíð",
               "",
               "Bangladesj summartíð",
               "",
               "Bangladesj tíð",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Grønhøvdaoyggjar vanlig tíð",
               "",
               "Grønhøvdaoyggjar summartíð",
               "",
               "Grønhøvdaoyggjar tíð",
               "",
            };
        final String[] East_Timor = new String[] {
               "Eysturtimor tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kasakstan tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seyskelloyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadsjikistan tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan vanlig tíð",
               "",
               "Usbekistan summartíð",
               "",
               "Usbekistan tíð",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk vanlig tíð",
               "",
               "Krasnoyarsk summartíð",
               "",
               "Krasnoyarsk tíð",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nýsæland vanlig tíð",
               "NZST",
               "Nýsæland summartíð",
               "NZDT",
               "Nýsæland tíð",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk vanlig tíð",
               "",
               "Novosibirsk summartíð",
               "",
               "Novosibirsk tíð",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipsoyggjar vanlig tíð",
               "PST",
               "Filipsoyggjar summartíð",
               "PDT",
               "Filipsoyggjar tíð",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok vanlig tíð",
               "",
               "Vladivostok summartíð",
               "",
               "Vladivostok tíð",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiahav tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lineoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland vanlig tíð",
               "NST",
               "Newfoundland summartíð",
               "NDT",
               "Newfoundland tíð",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan vanlig tíð",
               "",
               "Turkmenistan summartíð",
               "",
               "Turkmenistan tíð",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Franska Gujana tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nýkaledónia vanlig tíð",
               "",
               "Nýkaledónia summartíð",
               "",
               "Nýkaledónia tíð",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Suðurgeorgiaoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg vanlig tíð",
               "",
               "Yekaterinburg summartíð",
               "",
               "Yekaterinburg tíð",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Miðafrika tíð",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Eysturafrika tíð",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Vesturafrika vanlig tíð",
               "WAT",
               "Vesturafrika summartíð",
               "WAT",
               "Vesturafrika tíð",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Miðevropa vanlig tíð",
               "CET",
               "Miðevropa summartíð",
               "CEST",
               "Miðevropa tíð",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Eysturevropa vanlig tíð",
               "EET",
               "Eysturevropa summartíð",
               "EEST",
               "Eysturevropa tíð",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Vesturevropa vanlig tíð",
               "WET",
               "Vesturevropa summartíð",
               "WEST",
               "Vesturevropa tíð",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific vanlig tíð",
               "MST",
               "Mexican Pacific summartíð",
               "MDT",
               "Mexican Pacific tíð",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Suðurafrika vanlig tíð",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Central vanlig tíð",
               "CST",
               "Central summartíð",
               "CDT",
               "Central tíð",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern vanlig tíð",
               "EST",
               "Eastern summartíð",
               "EST",
               "Eastern tíð",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pacific vanlig tíð",
               "PST",
               "Pacific summartíð",
               "PDT",
               "Pacific tíð",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Fronsku sunnaru landaøki og Antarktis tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian vanlig tíð",
               "HST",
               "Hawaii-Aleutian summartíð",
               "HST",
               "Hawaii-Aleutian tíð",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixoyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon vanlig tíð",
               "",
               "St. Pierre & Miquelon summartíð",
               "",
               "St. Pierre & Miquelon tíð",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain vanlig tíð",
               "MST",
               "Mountain summartíð",
               "MST",
               "Mountain tíð",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalloyggjar tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nýguinea tíð",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "mið Avstralia vanlig tíð",
               "ACST",
               "mið Avstralia summartíð",
               "ACDT",
               "mið Avstralia tíð",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "eystur Avstralia vanlig tíð",
               "AEST",
               "eystur Avstralia summartíð",
               "AEDT",
               "eystur Avstralia tíð",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "vestur Avstralia vanlig tíð",
               "AWST",
               "vestur Avstralia summartíð",
               "AWDT",
               "vestur Avstralia tíð",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mið Indonesia tíð",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eystur Indonesia tíð",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur Indonesia tíð",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "miðvestur Avstralia vanlig tíð",
               "",
               "miðvestur Avstralia summartíð",
               "",
               "miðvestur Avstralia tíð",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Samskipað heimstíð",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Írsk vanlig tíð",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Samskipað heimstíð",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Samskipað heimstíð",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Samskipað heimstíð",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Samskipað heimstíð",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Samskipað heimstíð",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Írsk vanlig tíð",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean tíð",
                    "GMT",
                    "Bretsk summartíð",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "Gasa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Kuwait", "Kuvait" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Ókendur býur" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Athens", "Aten" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Varsjava" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "Belis" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Singapore", "Singapor" },
            { "timezone.excity.Europe/Vatican", "Vatikanið" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Azorurnar" },
            { "timezone.excity.Atlantic/Faeroe", "Føroyar" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Indian/Maldives", "Maldivoyggjar" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Stockholm", "Stokkhólm" },
            { "timezone.excity.Indian/Mauritius", "Móritius" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Europe/Copenhagen", "Keypmannahavn" },
            { "timezone.excity.Europe/Luxembourg", "Luksemborg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rika" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Riko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Grønhøvdaoyggjar" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Suðurgeorgiaoyggjar" },
        };
        return data;
    }
}
