/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ti extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "ጀርመን";
        final String metaValue_ar = "ዓረብኛ";
        final String metaValue_ccp = "ቻክማ";
        final String metaValue_km = "ክመር";
        final String metaValue_CA = "ካናዳ";
        final String metaValue_la = "ላቲን";
        final String metaValue_ml = "ማላያላም";
        final String metaValue_si = "ሲንሃላ";
        final String metaValue_ta = "ታሚል";
        final String metaValue_vai = "ቫይ";
        final Object[][] data = new Object[][] {
            { "001", "ዓለም" },
            { "002", "ኣፍሪቃ" },
            { "003", "ሰሜን ኣመሪካ" },
            { "005", "ደቡብ ኣመሪካ" },
            { "009", "ኦሽያንያ" },
            { "011", "ምዕራባዊ ኣፍሪቃ" },
            { "013", "ማእከላይ ኣመሪካ" },
            { "014", "ምብራቓዊ ኣፍሪቃ" },
            { "015", "ሰሜናዊ ኣፍሪቃ" },
            { "017", "ማእከላይ ኣፍሪቃ" },
            { "018", "ደቡባዊ ኣፍሪቃ" },
            { "019", "ኣመሪካታት" },
            { "021", "ሰሜናዊ ኣመሪካ" },
            { "029", "ካሪብያን" },
            { "030", "ምብራቓዊ ኤስያ" },
            { "034", "ደቡባዊ ኤስያ" },
            { "035", "ደቡባዊ ምብራቕ ኤስያ" },
            { "039", "ደቡባዊ ኤውሮጳ" },
            { "053", "ኣውስትራሌዥያ" },
            { "054", "መላነዥያ" },
            { "057", "ዞባ ማይክሮነዥያ" },
            { "061", "ፖሊነዥያ" },
            { "142", "ኤስያ" },
            { "143", "ማእከላይ ኤስያ" },
            { "145", "ምዕራባዊ ኤስያ" },
            { "150", "ኤውሮጳ" },
            { "151", "ምብራቓዊ ኤውሮጳ" },
            { "154", "ሰሜናዊ ኤውሮጳ" },
            { "155", "ምዕራባዊ ኤውሮጳ" },
            { "202", "ንኡስ ሰሃራዊ ኣፍሪቃ" },
            { "419", "ላቲን ኣመሪካ" },
            { "AC", "ደሴት ኣሰንስዮን" },
            { "AD", "ኣንዶራ" },
            { "AE", "ሕቡራት ኢማራት ዓረብ" },
            { "AF", "ኣፍጋኒስታን" },
            { "AG", "ኣንቲጓን ባርቡዳን" },
            { "AI", "ኣንጒላ" },
            { "AL", "ኣልባንያ" },
            { "AM", "ኣርሜንያ" },
            { "AO", "ኣንጎላ" },
            { "AQ", "ኣንታርክቲካ" },
            { "AR", "ኣርጀንቲና" },
            { "AS", "ኣመሪካዊት ሳሞኣ" },
            { "AT", "ኦስትርያ" },
            { "AU", "ኣውስትራልያ" },
            { "AW", "ኣሩባ" },
            { "AX", "ደሴታት ኣላንድ" },
            { "AZ", "ኣዘርባጃን" },
            { "BA", "ቦዝንያን ሄርዘጎቪናን" },
            { "BB", "ባርባዶስ" },
            { "BD", "ባንግላደሽ" },
            { "BE", "ቤልጅዩም" },
            { "BF", "ቡርኪና ፋሶ" },
            { "BG", "ቡልጋርያ" },
            { "BH", "ባሕሬን" },
            { "BI", "ብሩንዲ" },
            { "BJ", "ቤኒን" },
            { "BL", "ቅዱስ ባርተለሚ" },
            { "BM", "በርሙዳ" },
            { "BN", "ብሩነይ" },
            { "BO", "ቦሊቭያ" },
            { "BQ", "ካሪብያን ኔዘርላንድ" },
            { "BR", "ብራዚል" },
            { "BS", "ባሃማስ" },
            { "BT", "ቡታን" },
            { "BV", "ደሴት ቡቨት" },
            { "BW", "ቦትስዋና" },
            { "BY", "ቤላሩስ" },
            { "BZ", "በሊዝ" },
            { "CA", metaValue_CA },
            { "CC", "ደሴታት ኮኮስ" },
            { "CD", "ደሞክራስያዊት ሪፓብሊክ ኮንጎ" },
            { "CF", "ሪፓብሊክ ማእከላይ ኣፍሪቃ" },
            { "CG", "ኮንጎ" },
            { "CH", "ስዊዘርላንድ" },
            { "CI", "ኮት ዲቭዋር" },
            { "CK", "ደሴታት ኩክ" },
            { "CL", "ቺሌ" },
            { "CM", "ካሜሩን" },
            { "CN", "ቻይና" },
            { "CO", "ኮሎምብያ" },
            { "CP", "ደሴት ክሊፐርቶን" },
            { "CQ", "ሳርክ" },
            { "CR", "ኮስታ ሪካ" },
            { "CU", "ኩባ" },
            { "CV", "ኬፕ ቨርደ" },
            { "CW", "ኩራሳው" },
            { "CX", "ደሴት ክሪስማስ" },
            { "CY", "ቆጵሮስ" },
            { "CZ", "ቸክያ" },
            { "DE", metaValue_DE },
            { "DG", "ድየጎ ጋርስያ" },
            { "DJ", "ጅቡቲ" },
            { "DK", "ደንማርክ" },
            { "DM", "ዶሚኒካ" },
            { "DO", "ዶሚኒካዊት ሪፓብሊክ" },
            { "DZ", "ኣልጀርያ" },
            { "EA", "ሴውታን መሊላን" },
            { "EC", "ኤኳዶር" },
            { "EE", "ኤስቶንያ" },
            { "EG", "ግብጺ" },
            { "EH", "ምዕራባዊ ሰሃራ" },
            { "ER", "ኤርትራ" },
            { "ES", "ስጳኛ" },
            { "ET", "ኢትዮጵያ" },
            { "EU", "ኤውሮጳዊ ሕብረት" },
            { "EZ", "ዞባ ዩሮ" },
            { "FI", "ፊንላንድ" },
            { "FJ", "ፊጂ" },
            { "FK", "ደሴታት ፎክላንድ" },
            { "FM", "ማይክሮነዥያ" },
            { "FO", "ደሴታት ፋሮ" },
            { "FR", "ፈረንሳ" },
            { "GA", "ጋቦን" },
            { "GB", "ብሪጣንያ" },
            { "GD", "ግረናዳ" },
            { "GE", "ጆርጅያ" },
            { "GF", "ፈረንሳዊት ጊያና" },
            { "GG", "ገርንዚ" },
            { "GH", "ጋና" },
            { "GI", "ጂብራልታር" },
            { "GL", "ግሪንላንድ" },
            { "GM", "ጋምብያ" },
            { "GN", "ጊኒ" },
            { "GP", "ጓደሉፕ" },
            { "GQ", "ኢኳቶርያል ጊኒ" },
            { "GR", "ግሪኽ" },
            { "GS", "ደሴታት ደቡብ ጆርጅያን ደቡብ ሳንድዊችን" },
            { "GT", "ጓቲማላ" },
            { "GU", "ጓም" },
            { "GW", "ጊኒ-ቢሳው" },
            { "GY", "ጉያና" },
            { "HK", "ፍሉይ ምምሕዳራዊ ዞባ ሆንግ ኮንግ (ቻይና)" },
            { "HM", "ደሴታት ሄርድን ማክዶናልድን" },
            { "HN", "ሆንዱራስ" },
            { "HR", "ክሮኤሽያ" },
            { "HT", "ሃይቲ" },
            { "HU", "ሃንጋሪ" },
            { "IC", "ደሴታት ካናሪ" },
            { "ID", "ኢንዶነዥያ" },
            { "IE", "ኣየርላንድ" },
            { "IL", "እስራኤል" },
            { "IM", "ኣይል ኦፍ ማን" },
            { "IN", "ህንዲ" },
            { "IO", "ብሪጣንያዊ ህንዳዊ ውቅያኖስ ግዝኣት" },
            { "IQ", "ዒራቕ" },
            { "IR", "ኢራን" },
            { "IS", "ኣይስላንድ" },
            { "IT", "ኢጣልያ" },
            { "JE", "ጀርዚ" },
            { "JM", "ጃማይካ" },
            { "JO", "ዮርዳኖስ" },
            { "JP", "ጃፓን" },
            { "KE", "ኬንያ" },
            { "KG", "ኪርጊዝስታን" },
            { "KH", "ካምቦድያ" },
            { "KI", "ኪሪባቲ" },
            { "KM", "ኮሞሮስ" },
            { "KN", "ቅዱስ ኪትስን ኔቪስን" },
            { "KP", "ሰሜን ኮርያ" },
            { "KR", "ደቡብ ኮርያ" },
            { "KW", "ኩዌት" },
            { "KY", "ደሴታት ካይማን" },
            { "KZ", "ካዛኪስታን" },
            { "LA", "ላኦስ" },
            { "LB", "ሊባኖስ" },
            { "LC", "ቅድስቲ ሉስያ" },
            { "LI", "ሊኽተንሽታይን" },
            { "LK", "ስሪ ላንካ" },
            { "LR", "ላይበርያ" },
            { "LS", "ሌሶቶ" },
            { "LT", "ሊትዌንያ" },
            { "LU", "ሉክሰምበርግ" },
            { "LV", "ላትቭያ" },
            { "LY", "ሊብያ" },
            { "MA", "ሞሮኮ" },
            { "MC", "ሞናኮ" },
            { "MD", "ሞልዶቫ" },
            { "ME", "ሞንተኔግሮ" },
            { "MF", "ቅዱስ ማርቲን" },
            { "MG", "ማዳጋስካር" },
            { "MH", "ደሴታት ማርሻል" },
            { "MK", "ሰሜን መቄዶንያ" },
            { "ML", "ማሊ" },
            { "MM", "ሚያንማር (በርማ)" },
            { "MN", "ሞንጎልያ" },
            { "MO", "ፍሉይ ምምሕዳራዊ ዞባ ማካው (ቻይና)" },
            { "MP", "ሰሜናዊ ደሴታት ማርያና" },
            { "MQ", "ማርቲኒክ" },
            { "MR", "ማውሪታንያ" },
            { "MS", "ሞንትሰራት" },
            { "MT", "ማልታ" },
            { "MU", "ማውሪሸስ" },
            { "MV", "ማልዲቭስ" },
            { "MW", "ማላዊ" },
            { "MX", "ሜክሲኮ" },
            { "MY", "ማለዥያ" },
            { "MZ", "ሞዛምቢክ" },
            { "NA", "ናሚብያ" },
            { "NC", "ኒው ካለዶንያ" },
            { "NE", "ኒጀር" },
            { "NF", "ደሴት ኖርፎልክ" },
            { "NG", "ናይጀርያ" },
            { "NI", "ኒካራጓ" },
            { "NL", "ኔዘርላንድ" },
            { "NO", "ኖርወይ" },
            { "NP", "ኔፓል" },
            { "NR", "ናውሩ" },
            { "NU", "ኒዩ" },
            { "NZ", "ኒው ዚላንድ" },
            { "OM", "ዖማን" },
            { "PA", "ፓናማ" },
            { "PE", "ፔሩ" },
            { "PF", "ፈረንሳዊት ፖሊነዥያ" },
            { "PG", "ፓፕዋ ኒው ጊኒ" },
            { "PH", "ፊሊፒንስ" },
            { "PK", "ፓኪስታን" },
            { "PL", "ፖላንድ" },
            { "PM", "ቅዱስ ፕየርን ሚከሎንን" },
            { "PN", "ደሴታት ፒትካርን" },
            { "PR", "ፖርቶ ሪኮ" },
            { "PS", "ግዝኣታት ፍልስጤም" },
            { "PT", "ፖርቱጋል" },
            { "PW", "ፓላው" },
            { "PY", "ፓራጓይ" },
            { "QA", "ቐጠር" },
            { "QO", "ካብ ኦሽያንያ ርሒቖም ግዝኣታት" },
            { "RE", "ርዩንየን" },
            { "RO", "ሩማንያ" },
            { "RS", "ሰርብያ" },
            { "RU", "ሩስያ" },
            { "RW", "ርዋንዳ" },
            { "SA", "ስዑዲ ዓረብ" },
            { "SB", "ደሴታት ሰሎሞን" },
            { "SC", "ሲሸልስ" },
            { "SD", "ሱዳን" },
            { "SE", "ሽወደን" },
            { "SG", "ሲንጋፖር" },
            { "SH", "ቅድስቲ ሄለና" },
            { "SI", "ስሎቬንያ" },
            { "SJ", "ስቫልባርድን ጃን ማየንን" },
            { "SK", "ስሎቫክያ" },
            { "SL", "ሴራ ልዮን" },
            { "SM", "ሳን ማሪኖ" },
            { "SN", "ሰነጋል" },
            { "SO", "ሶማልያ" },
            { "SR", "ሱሪናም" },
            { "SS", "ደቡብ ሱዳን" },
            { "ST", "ሳኦ ቶመን ፕሪንሲፐን" },
            { "SV", "ኤል ሳልቫዶር" },
            { "SX", "ሲንት ማርተን" },
            { "SY", "ሶርያ" },
            { "SZ", "ኤስዋቲኒ" },
            { "TA", "ትሪስታን ዳ ኩንያ" },
            { "TC", "ደሴታት ቱርካትን ካይኮስን" },
            { "TD", "ቻድ" },
            { "TF", "ፈረንሳዊ ደቡባዊ ግዝኣታት" },
            { "TG", "ቶጎ" },
            { "TH", "ታይላንድ" },
            { "TJ", "ታጂኪስታን" },
            { "TK", "ቶከላው" },
            { "TL", "ቲሞር-ለስተ" },
            { "TM", "ቱርክመኒስታን" },
            { "TN", "ቱኒዝያ" },
            { "TO", "ቶንጋ" },
            { "TR", "ቱርኪ" },
            { "TT", "ትሪኒዳድን ቶባጎን" },
            { "TV", "ቱቫሉ" },
            { "TW", "ታይዋን" },
            { "TZ", "ታንዛንያ" },
            { "UA", "ዩክሬን" },
            { "UG", "ኡጋንዳ" },
            { "UM", "ካብ ኣመሪካ ርሒቐን ንኣሽቱ ደሴታት" },
            { "UN", "ሕቡራት ሃገራት" },
            { "US", "ኣመሪካ" },
            { "UY", "ኡራጓይ" },
            { "UZ", "ኡዝበኪስታን" },
            { "VA", "ከተማ ቫቲካን" },
            { "VC", "ቅዱስ ቪንሰንትን ግረነዲነዝን" },
            { "VE", "ቬኔዝዌላ" },
            { "VG", "ደሴታት ደናግል ብሪጣንያ" },
            { "VI", "ደሴታት ደናግል ኣመሪካ" },
            { "VN", "ቬትናም" },
            { "VU", "ቫንዋቱ" },
            { "WF", "ዋሊስን ፉቱናን" },
            { "WS", "ሳሞኣ" },
            { "XA", "ናይ ሓሶት ላህጃታት" },
            { "XB", "ናይ ሓሶት ክልተ ኣንፈታዊ" },
            { "XK", "ኮሶቮ" },
            { "YE", "የመን" },
            { "YT", "ማዮት" },
            { "ZA", "ደቡብ ኣፍሪቃ" },
            { "ZM", "ዛምብያ" },
            { "ZW", "ዚምባብዌ" },
            { "ZZ", "ዘይተፈልጠ ዞባ" },
            { "aa", "አፋር" },
            { "ab", "ኣብካዝኛ" },
            { "af", "ኣፍሪካንስ" },
            { "ak", "ኣካን" },
            { "am", "ኣምሓርኛ" },
            { "an", "ኣራጎንኛ" },
            { "ar", metaValue_ar },
            { "as", "ኣሳሜዝኛ" },
            { "av", "ኣቫርኛ" },
            { "ay", "ኣይማራ" },
            { "az", "ኣዘርባጃንኛ" },
            { "ba", "ባሽኪር" },
            { "be", "ቤላሩስኛ" },
            { "bg", "ቡልጋርኛ" },
            { "bi", "ቢስላማ" },
            { "bm", "ባምባራ" },
            { "bn", "በንጋሊ" },
            { "bo", "ቲበታንኛ" },
            { "br", "ብረቶንኛ" },
            { "bs", "ቦዝንኛ" },
            { "ca", "ካታላን" },
            { "ce", "ቸቸንይና" },
            { "ch", "ቻሞሮ" },
            { "co", "ኮርስኛ" },
            { "cs", "ቸክኛ" },
            { "cu", "ቤተ-ክርስትያን ስላቭኛ" },
            { "cv", "ቹቫሽኛ" },
            { "cy", "ዌልስኛ" },
            { "da", "ዳኒሽ" },
            { "de", metaValue_DE },
            { "dv", "ዲቨሂ" },
            { "dz", "ድዞንግካ" },
            { "ee", "ኢው" },
            { "el", "ግሪኽኛ" },
            { "en", "እንግሊዝኛ" },
            { "eo", "ኤስፐራንቶ" },
            { "es", "ስጳንኛ" },
            { "et", "ኤስቶንኛ" },
            { "eu", "ባስክኛ" },
            { "fa", "ፋርስኛ" },
            { "ff", "ፉላ" },
            { "fi", "ፊንላንድኛ" },
            { "fj", "ፊጅያንኛ" },
            { "fo", "ፋሮእይና" },
            { "fr", "ፈረንሳይኛ" },
            { "fy", "ምዕራባዊ ፍሪስኛ" },
            { "ga", "ኣየርላንድኛ" },
            { "gd", "ስኮትላንዳዊ ጋኤሊክኛ" },
            { "gl", "ጋሊሽያን" },
            { "gn", "ጓራኒ" },
            { "gu", "ጉጃራቲ" },
            { "gv", "ማንክስ" },
            { "ha", "ሃውሳ" },
            { "he", "እብራይስጢ" },
            { "hi", "ሂንዲ" },
            { "hr", "ክሮኤሽያን" },
            { "ht", "ክርዮል ሃይትኛ" },
            { "hu", "ሃንጋርኛ" },
            { "hy", "ኣርሜንኛ" },
            { "hz", "ሄረሮ" },
            { "ia", "ኢንተርሊንጓ" },
            { "id", "ኢንዶነዥኛ" },
            { "ie", "ኢንተርሊንጔ" },
            { "ig", "ኢግቦ" },
            { "ii", "ሲችዋን ዪ" },
            { "io", "ኢዶ" },
            { "is", "ኣይስላንድኛ" },
            { "it", "ጥልያን" },
            { "iu", "ኢናክቲቱት" },
            { "ja", "ጃፓንኛ" },
            { "jv", "ጃቫንኛ" },
            { "ka", "ጆርጅያንኛ" },
            { "ki", "ኪኩዩ" },
            { "kj", "ክዋንያማ" },
            { "kk", "ካዛክ" },
            { "kl", "ግሪንላንድኛ" },
            { "km", metaValue_km },
            { "kn", "ካንናዳ" },
            { "ko", "ኮርይኛ" },
            { "kr", "ካኑሪ" },
            { "ks", "ካሽሚሪ" },
            { "ku", "ኩርዲሽ" },
            { "kv", "ኮሚ" },
            { "kw", "ኮርንኛ" },
            { "ky", "ኪርጊዝኛ" },
            { "la", metaValue_la },
            { "lb", "ሉክሰምበርግኛ" },
            { "lg", "ጋንዳ" },
            { "li", "ሊምበርግኛ" },
            { "ln", "ሊንጋላ" },
            { "lo", "ላኦ" },
            { "lt", "ሊትዌንኛ" },
            { "lu", "ሉባ-ካታንጋ" },
            { "lv", "ላትቭኛ" },
            { "mg", "ማላጋሲ" },
            { "mh", "ማርሻሊዝኛ" },
            { "mi", "ማኦሪ" },
            { "mk", "መቄዶንኛ" },
            { "ml", metaValue_ml },
            { "mn", "ሞንጎልኛ" },
            { "mr", "ማራቲ" },
            { "ms", "ማላይኛ" },
            { "mt", "ማልትኛ" },
            { "my", "በርምኛ" },
            { "na", "ናውርዋንኛ" },
            { "nb", "ኖርወያዊ ቦክማል" },
            { "nd", "ሰሜን ኤንደበለ" },
            { "ne", "ኔፓሊ" },
            { "ng", "ኤንዶንጋ" },
            { "nl", "ዳች" },
            { "nn", "ኖርወያዊ ናይኖርስክ" },
            { "no", "ኖርወይኛ" },
            { "nr", "ደቡብ ኤንደበለ" },
            { "nv", "ናቫሆ" },
            { "ny", "ንያንጃ" },
            { "oc", "ኦክሲታንኛ" },
            { "om", "ኦሮሞ" },
            { "or", "ኦድያ" },
            { "os", "ኦሰትኛ" },
            { "pa", "ፑንጃቢ" },
            { "pl", "ፖሊሽ" },
            { "ps", "ፓሽቶ" },
            { "pt", "ፖርቱጊዝኛ" },
            { "qu", "ቀችዋ" },
            { "rm", "ሮማንሽ" },
            { "rn", "ኪሩንዲ" },
            { "ro", "ሩማንኛ" },
            { "ru", "ሩስኛ" },
            { "rw", "ኪንያርዋንዳ" },
            { "sa", "ሳንስክሪት" },
            { "sc", "ሳርዲንኛ" },
            { "sd", "ሲንድሂ" },
            { "se", "ሰሜናዊ ሳሚ" },
            { "sg", "ሳንጎ" },
            { "sh", "ሰርቦ-ክሮኤሽያኛ" },
            { "si", metaValue_si },
            { "sk", "ስሎቫክኛ" },
            { "sl", "ስሎቬንኛ" },
            { "sm", "ሳሞእኛ" },
            { "sn", "ሾና" },
            { "so", "ሶማሊ" },
            { "sq", "ኣልባንኛ" },
            { "sr", "ሰርቢያኛ" },
            { "ss", "ስዋዚ" },
            { "st", "ደቡባዊ ሶቶ" },
            { "su", "ሱዳንኛ" },
            { "sv", "ስዊድንኛ" },
            { "sw", "ስዋሂሊ" },
            { "ta", metaValue_ta },
            { "te", "ተሉጉ" },
            { "tg", "ታጂክኛ" },
            { "th", "ታይኛ" },
            { "ti", "ትግርኛ" },
            { "tk", "ቱርክመንኛ" },
            { "tn", "ስዋና" },
            { "to", "ቶንጋንኛ" },
            { "tr", "ቱርክኛ" },
            { "ts", "ሶንጋ" },
            { "tt", "ታታር" },
            { "tw", "ትዊ" },
            { "ty", "ታሂትኛ" },
            { "ug", "ኡይጉር" },
            { "uk", "ዩክረይንኛ" },
            { "ur", "ኡርዱ" },
            { "uz", "ኡዝበክኛ" },
            { "ve", "ቨንዳ" },
            { "vi", "ቬትናምኛ" },
            { "vo", "ቮላፑክ" },
            { "wa", "ዋሎን" },
            { "wo", "ዎሎፍ" },
            { "xh", "ኮሳ" },
            { "yi", "ይሁድኛ" },
            { "yo", "ዮሩባ" },
            { "za", "ዙኣንግ" },
            { "zh", "ቻይንኛ" },
            { "zu", "ዙሉ" },
            { "ace", "ኣቸኒዝኛ" },
            { "ada", "ኣዳንግሜ" },
            { "ady", "ኣዲጊ" },
            { "agq", "ኣገም" },
            { "ain", "ኣይኑ" },
            { "ale", "ኣለውትኛ" },
            { "alt", "ደቡባዊ ኣልታይ" },
            { "ann", "ኦቦሎ" },
            { "anp", "ኣንጂካ" },
            { "apc", "ሌቫንቲናዊ ዓረብኛ" },
            { "arn", "ማፑቺ" },
            { "arp", "ኣራፓሆ" },
            { "ars", "ናጅዲ ዓረብኛ" },
            { "asa", "ኣሱ" },
            { "ast", "ኣስቱርያን" },
            { "atj", "ኣቲካመክ" },
            { "awa", "ኣዋዲ" },
            { "bal", "ባሉቺ" },
            { "ban", "ባሊንኛ" },
            { "bas", "ባሳ" },
            { "bem", "ቤምባ" },
            { "bew", "ቤታዊ" },
            { "bez", "በና" },
            { "bgc", "ሃርያንቪ" },
            { "bgn", "ምዕራባዊ ባሎቺ" },
            { "bho", "ቦጅፑሪ" },
            { "bin", "ቢኒ" },
            { "bla", "ሲክሲካ" },
            { "blo", "ኣኒ" },
            { "blt", "ታይ ዳም" },
            { "brx", "ቦዶ" },
            { "bss", "ኣኮስ" },
            { "bug", "ቡጊንኛ" },
            { "byn", "ብሊን" },
            { "cad", "ካድዶ" },
            { "cay", "ካዩጋ" },
            { "cch", "ኣትሳም" },
            { "ccp", metaValue_ccp },
            { "ceb", "ሰብዋኖ" },
            { "cgg", "ቺጋ" },
            { "chk", "ቹኪዝኛ" },
            { "chm", "ማሪ" },
            { "cho", "ቾክቶ" },
            { "chp", "ቺፐውያን" },
            { "chr", "ቸሮኪ" },
            { "chy", "ሻያን" },
            { "cic", "ቺካሳው" },
            { "ckb", "ማእከላይ ኩርዲሽ" },
            { "clc", "ቺልኮቲን" },
            { "crg", "ሚቺፍ" },
            { "crj", "ደቡባዊ ምብራቕ ክሪ" },
            { "crk", "ክሪ ፕሌንስ" },
            { "crl", "ሰሜናዊ ምብራቕ ክሪ" },
            { "crm", "ሙስ ክሪ" },
            { "crr", "ካሮሊና አልጎንጉያኛ" },
            { "csw", "ክሪ ረግረግ" },
            { "dak", "ዳኮታ" },
            { "dar", "ዳርግዋ" },
            { "dav", "ታይታ" },
            { "dgr", "ዶግሪብ" },
            { "dje", "ዛርማ" },
            { "doi", "ዶግሪ" },
            { "dsb", "ታሕተዋይ ሶርብኛ" },
            { "dua", "ድዋላ" },
            { "dyo", "ጆላ-ፎኒይ" },
            { "dzg", "ዳዛጋ" },
            { "ebu", "ኤምቡ" },
            { "efi", "ኤፊክ" },
            { "eka", "ኤካጁክ" },
            { "ewo", "ኤዎንዶ" },
            { "fil", "ፊሊፒንኛ" },
            { "fon", "ፎን" },
            { "frc", "ካጁን ፈረንሳይ" },
            { "frr", "ሰሜናዊ ፍሪስኛ" },
            { "fur", "ፍርዩልኛ" },
            { "gaa", "ጋ" },
            { "gez", "ግእዝ" },
            { "gil", "ጊልበርትኛ" },
            { "gor", "ጎሮንታሎ" },
            { "gsw", "ስዊዘርላንዳዊ ጀርመን" },
            { "guz", "ጉሲ" },
            { "gwi", "ጒቺን" },
            { "hai", "ሃይዳ" },
            { "haw", "ሃዋይኛ" },
            { "hax", "ደቡባዊ ሃይዳ" },
            { "hil", "ሂሊጋይኖን" },
            { "hmn", "ህሞንግ" },
            { "hnj", "ህሞንግ ንጁዋ" },
            { "hsb", "ላዕለዋይ ሶርብኛ" },
            { "hup", "ሁፓ" },
            { "hur", "ሃልኮመለም" },
            { "iba", "ኢባን" },
            { "ibb", "ኢቢብዮ" },
            { "ikt", "ምዕራባዊ ካናዳዊ ኢናክቲቱት" },
            { "ilo", "ኢሎካኖ" },
            { "inh", "ኢንጉሽኛ" },
            { "jbo", "ሎጅባን" },
            { "jgo", "ኤንጎምባ" },
            { "jmc", "ማኬም" },
            { "kaa", "ካራ-ካልፓክ" },
            { "kab", "ካቢልኛ" },
            { "kac", "ካቺን" },
            { "kaj", "ጅጁ" },
            { "kam", "ካምባ" },
            { "kbd", "ካባርድኛ" },
            { "kcg", "ታያፕ" },
            { "kde", "ማኮንደ" },
            { "kea", "ክርዮል ኬፕ ቨርድኛ" },
            { "ken", "ኬንያንግ" },
            { "kfo", "ኮሮ" },
            { "kgp", "ካይንጋንግ" },
            { "kha", "ካሲ" },
            { "khq", "ኮይራ ቺኒ" },
            { "kkj", "ካኮ" },
            { "kln", "ካለንጂን" },
            { "kmb", "ኪምቡንዱ" },
            { "kok", "ኮንካኒ" },
            { "kpe", "ክፐለ" },
            { "krc", "ካራቻይ-ባልካርኛ" },
            { "krl", "ካረልኛ" },
            { "kru", "ኩሩክ" },
            { "ksb", "ሻምባላ" },
            { "ksf", "ባፍያ" },
            { "ksh", "ኮሎግኒያን" },
            { "kum", "ኩሚይክ" },
            { "kwk", "ክዋክዋላ" },
            { "kxv", "ኩቪ" },
            { "lad", "ላዲኖ" },
            { "lag", "ላንጊ" },
            { "lez", "ለዝግኛ" },
            { "lij", "ሊጉርኛ" },
            { "lil", "ሊሉት" },
            { "lkt", "ላኮታ" },
            { "lmo", "ሎምባርድኛ" },
            { "lou", "ክርዮል ሉዊዝያና" },
            { "loz", "ሎዚ" },
            { "lrc", "ሰሜናዊ ሉሪ" },
            { "lsm", "ሳምያ" },
            { "ltg", "ላትጋላዊ" },
            { "lua", "ሉባ-ሉልዋ" },
            { "lun", "ሉንዳ" },
            { "luo", "ሉኦ" },
            { "lus", "ማይዞ" },
            { "luy", "ሉይያ" },
            { "mad", "ማዱሪዝኛ" },
            { "mag", "ማጋሂ" },
            { "mai", "ማይቲሊ" },
            { "mak", "ማካሳር" },
            { "mas", "ማሳይ" },
            { "mdf", "ሞክሻ" },
            { "men", "መንዴ" },
            { "mer", "መሩ" },
            { "mfe", "ክርዮል ማውሪሽይና" },
            { "mgh", "ማክዋ-ሜቶ" },
            { "mgo", "መታ" },
            { "mic", "ሚክማክ" },
            { "min", "ሚናንግካባው" },
            { "mni", "ማኒፑሪ" },
            { "moe", "ኢኑ-ኤመን" },
            { "moh", "ሞሃውክ" },
            { "mos", "ሞሲ" },
            { "mua", "ሙንዳንግ" },
            { "mul", "ዝተፈላለዩ ቋንቋታት" },
            { "mus", "ክሪክ" },
            { "mwl", "ሚራንዲዝኛ" },
            { "myv", "ኤርዝያ" },
            { "mzn", "ማዛንደራኒ" },
            { "nap", "ኒያፖሊታንኛ" },
            { "naq", "ናማ" },
            { "nds", "ትሑት ጀርመን" },
            { "new", "ነዋሪ" },
            { "nia", "ንያስ" },
            { "niu", "ንዌንኛ" },
            { "nmg", "ክዋስዮ" },
            { "nnh", "ኤንጌምቡን" },
            { "nog", "ኖጋይኛ" },
            { "nqo", "ኤንኮ" },
            { "nso", "ሰሜናዊ ሶቶ" },
            { "nus", "ንዌር" },
            { "nyn", "ንያንኮል" },
            { "ojb", "ሰሜናዊ ምዕራብ ኦጂብዋ" },
            { "ojc", "ማእከላይ ኦጂብዋ" },
            { "ojs", "ኦጂ-ክሪ" },
            { "ojw", "ምዕራባዊ ኦጂብዋ" },
            { "oka", "ኦካናጋን" },
            { "osa", "ኦሳጌ" },
            { "pag", "ፓንጋሲናን" },
            { "pam", "ፓምፓንጋ" },
            { "pap", "ፓፕያመንቶ" },
            { "pau", "ፓላውኛ" },
            { "pcm", "ፒጂን ናይጀርያ" },
            { "pis", "ፒጂን" },
            { "pqm", "ማሊሲት-ፓሳማኳዲ" },
            { "prg", "ፕሩስኛ" },
            { "quc", "ኪቼ" },
            { "raj", "ራጃስታኒ" },
            { "rap", "ራፓኑይ" },
            { "rar", "ራሮቶንጋንኛ" },
            { "rhg", "ሮሂንግያ" },
            { "rif", "ሪፍኛ" },
            { "rof", "ሮምቦ" },
            { "rup", "ኣሩማንኛ" },
            { "rwk", "ርዋ" },
            { "sad", "ሳንዳወ" },
            { "sah", "ሳኻ" },
            { "saq", "ሳምቡሩ" },
            { "sat", "ሳንታሊ" },
            { "sba", "ኤንጋምባይ" },
            { "sbp", "ሳንጉ" },
            { "scn", "ሲሲልኛ" },
            { "sco", "ስኮትኛ" },
            { "sdh", "ደቡባዊ ኩርዲሽ" },
            { "seh", "ሰና" },
            { "ses", "ኮይራቦሮ ሰኒ" },
            { "shi", "ታቸልሂት" },
            { "shn", "ሻን" },
            { "sid", "ሲዳመኛ" },
            { "slh", "ደቡባዊ ሉሹትሲድ" },
            { "sma", "ደቡባዊ ሳሚ" },
            { "smj", "ሉለ ሳሚ" },
            { "smn", "ሳሚ ኢናሪ" },
            { "sms", "ሳሚ ስኮልት" },
            { "snk", "ሶኒንከ" },
            { "srn", "ስራናን ቶንጎ" },
            { "ssy", "ሳሆ" },
            { "str", "ሳሊሽ መጻብቦታት" },
            { "suk", "ሱኩማ" },
            { "swb", "ኮሞርኛ" },
            { "syr", "ሶርያኛ" },
            { "szl", "ሲሌሲያን" },
            { "tce", "ደቡባዊ ታትቾን" },
            { "tem", "ቲምኔ" },
            { "teo", "ተሶ" },
            { "tet", "ቲተም" },
            { "tgx", "ታጊሽ" },
            { "tht", "ታልተን" },
            { "tig", "ትግረ" },
            { "tlh", "ክሊንጎን" },
            { "tli", "ትሊንጊት" },
            { "tok", "ቶኪ ፖና" },
            { "tpi", "ቶክ ፒሲን" },
            { "trv", "ታሮኮ" },
            { "trw", "ቶርዋሊኛ" },
            { "ttm", "ሰሜናዊ ታትቾን" },
            { "tum", "ተምቡካ" },
            { "tvl", "ቱቫልዋንኛ" },
            { "twq", "ታሳዋቅ" },
            { "tyv", "ቱቪንኛ" },
            { "tzm", "ማእከላይ ኣትላስ ታማዛይት" },
            { "udm", "ዩድሙርት" },
            { "umb", "ኣምቡንዱ" },
            { "und", "ዘይተፈልጠ ቋንቋ" },
            { "vai", metaValue_vai },
            { "vec", "ቬንቲያንኛ" },
            { "vmw", "ማክሁዋ" },
            { "vun", "ቩንጆ" },
            { "wae", "ዋልሰር" },
            { "wal", "ዎላይታኛ" },
            { "war", "ዋራይ" },
            { "wbp", "ዋርልፒሪ" },
            { "wuu", "ቻይናዊ ዉ" },
            { "xal", "ካልምይክ" },
            { "xnr", "ካንጋሪኛ" },
            { "xog", "ሶጋ" },
            { "yav", "ያንግበን" },
            { "ybb", "የምባ" },
            { "yrl", "ኒንጋቱ" },
            { "yue", "ካንቶንኛ" },
            { "zgh", "ሞሮካዊ ምዱብ ታማዛይት" },
            { "zun", "ዙኚ" },
            { "zxx", "ቋንቋዊ ትሕዝቶ የለን" },
            { "zza", "ዛዛኪ" },
            { "Adlm", "አድላም" },
            { "Arab", metaValue_ar },
            { "Aran", "ናስታሊ" },
            { "Armn", "ዓይቡቤን" },
            { "Beng", "ቋንቋ ቤንጋል" },
            { "Bopo", "ቦፖሞፎ" },
            { "Brai", "ብሬል" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ውሁድ ካናዳዊ ኣቦርጅናል ሲላቢክስ" },
            { "Cher", "ቼሪዮክ" },
            { "Cyrl", "ቋንቋ ሲሪል" },
            { "Deva", "ዴቫንጋሪ" },
            { "Ethi", "እትዮጵያዊ" },
            { "Geor", "ናይ ጆርጅያ" },
            { "Grek", "ግሪክ" },
            { "Gujr", "ጉጃርቲ" },
            { "Guru", "ጉርሙኪ" },
            { "Hanb", "ሃን ምስ ቦፖሞፎ" },
            { "Hang", "ሃንጉል" },
            { "Hani", "ሃን" },
            { "Hans", "ዝተቐለለ" },
            { "Hant", "ባህላዊ" },
            { "Hebr", "ኢብራይስጥ" },
            { "Hira", "ሂራጋና" },
            { "Hrkt", "ጃፓናዊ ሲለባሪታት" },
            { "Jamo", "ጃሞ" },
            { "Jpan", "ጃፓናዊ" },
            { "Kana", "ካታካና" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_CA },
            { "Kore", "ኮርያዊ" },
            { "Laoo", "ሌኦ" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "ማኦንጎላዊ" },
            { "Mtei", "መይተይ ማየክ" },
            { "Mymr", "ማይንማር" },
            { "Nkoo", "ንኮ" },
            { "Olck", "ኦል ቺኪ" },
            { "Orya", "ኦዲያ" },
            { "Rohg", "ሃኒፊ" },
            { "Sinh", metaValue_si },
            { "Sund", "ሱንዳናዊ" },
            { "Syrc", "ስይሪክ" },
            { "Taml", metaValue_ta },
            { "Telu", "ቴሉጉ" },
            { "Tfng", "ቲፊንጋ" },
            { "Thaa", "ትሃና" },
            { "Thai", "ታይ" },
            { "Tibt", "ቲቤት" },
            { "Vaii", metaValue_vai },
            { "Yiii", "ዪ" },
            { "Zmth", "ናይ ሒሳብ ምልክት" },
            { "Zsye", "ኢሞጂ" },
            { "Zsym", "ምልክታት" },
            { "Zxxx", "ዘይተጻሕፈ" },
            { "Zyyy", "ልሙድ" },
            { "Zzzz", "ዘይፍለጥ ኢደ ጽሑፍ" },
            { "es_ES", "ስጳንኛ (ኤውሮጳዊ)" },
            { "fa_AF", "ዳሪ" },
            { "nl_BE", "ፍላሚሽ" },
            { "ro_MD", "ሞልዶቨኛ" },
            { "sw_CD", "ስዋሂሊ (ኮንጎ)" },
            { "ar_001", "ዘመናዊ ምዱብ ዓረብኛ" },
            { "key.ca", "ዓውደ-ኣዋርሕ" },
            { "key.cf", "ቅርጺ ባጤራ" },
            { "key.co", "ስርዓት ምድላው" },
            { "key.cu", "ባጤራ" },
            { "key.hc", "ዑደት ሰዓት (12 ኣንጻር 24)" },
            { "key.lb", "ቅዲ ምብታኽ መስመር" },
            { "key.ms", "ስርዓት መለክዒ" },
            { "key.nu", "ቁጽርታት" },
            { "nds_NL", "ትሑት ሳክሰን" },
            { "zh_Hans", "ቀሊል ቻይንኛ" },
            { "zh_Hant", "ባህላዊ ቻይንኛ" },
            { "%%1959ACAD", "ኣካዳምያዊ" },
            { "type.ca.roc", "ናይ ሪፓብሊክ ቻይና ዓውደ ኣዋርሕ" },
            { "type.hc.h11", "ስርዓት 12 ሰዓታት (0–11)" },
            { "type.hc.h12", "ስርዓት 12 ሰዓታት (1–12)" },
            { "type.hc.h23", "ናይ 24 ሰዓታት ስርዓት (0–23)" },
            { "type.hc.h24", "ናይ 24 ሰዓታት ስርዓት (1–24)" },
            { "type.nu.arab", "ዓረብ-ህንዳዊ ኣሃዛት" },
            { "type.nu.armn", "ኣርመንያዊ ቁጽርታት" },
            { "type.nu.beng", "ባንግላ ኣሃዛት" },
            { "type.nu.cakm", "ቻክማ ኣሃዛት" },
            { "type.nu.deva", "ደቫናጋሪ ኣሃዛት" },
            { "type.nu.ethi", "ግእዝ ቁጽርታት" },
            { "type.nu.geor", "ጆርጅያዊ ቁጽርታት" },
            { "type.nu.grek", "ናይ ግሪኽ ቁጽርታት" },
            { "type.nu.gujr", "ናይ ጉጃራቲ ኣሃዛት" },
            { "type.nu.guru", "ናይ ጉርሙኪ ኣሃዛት" },
            { "type.nu.hans", "ዝተቐለለ ቻይናዊ ቁጽርታት" },
            { "type.nu.hant", "ባህላዊ ቁጽርታት ቻይና" },
            { "type.nu.hebr", "ናይ እብራይስጢ ቁጽርታት" },
            { "type.nu.java", "ጃቫናዊ ኣሃዛት" },
            { "type.nu.jpan", "ጃፓናዊ ቁጽርታት" },
            { "type.nu.khmr", "ኣሃዛት ክመር" },
            { "type.nu.knda", "ካናዳ ኣሃዛት" },
            { "type.nu.laoo", "ላኦ ዲጂትስ" },
            { "type.nu.latn", "ምዕራባዊ ኣሃዛት" },
            { "type.nu.mlym", "ማላያላም ኣሃዛት" },
            { "type.nu.mtei", "ሜተይ ማየክ ኣሃዛት" },
            { "type.nu.mymr", "ናይ ሚያንማር ኣሃዛት" },
            { "type.nu.olck", "ኦል ቺኪ ኣሃዛት" },
            { "type.nu.orya", "ኦድያ አሃዛት" },
            { "type.nu.taml", "ባህላዊ ቁጽርታት ታሚል" },
            { "type.nu.telu", "ናይ ተለጉ አሃዛት" },
            { "type.nu.thai", "ናይ ታይላንዳዊ ኣሃዛት" },
            { "type.nu.tibt", "ናይ ትቤቲ ኣሃዛት" },
            { "type.nu.vaii", "ቫይ ኣሃዛት" },
            { "type.ca.dangi", "ናይ ዳንጊ ዓውደ ኣዋርሕ" },
            { "type.co.ducet", "ነባሪ ዩኒኮድ ስርዓት ምድላው" },
            { "type.lb.loose", "ልሕሉሕ መስመር ምብታኽ ቅዲ" },
            { "type.nu.roman", "ሮማዊ ቁጽርታት" },
            { "type.ca.coptic", "ናይ ቅብጣዊ ዓውደ ኣዋርሕ" },
            { "type.ca.hebrew", "ናይ እብራይስጢ ዓውደ ኣዋርሕ" },
            { "type.co.search", "ሓፈሻዊ-ዕላማ ምድላይ" },
            { "type.lb.normal", "ንቡር ቅዲ ምብታኽ መስመር" },
            { "type.lb.strict", "ቅዲ ስጡም መስመር ምብታኽ" },
            { "type.ms.metric", "ሜትሪክ ስርዓት" },
            { "type.ca.chinese", "ናይ ቻይናዊ ዓውደ ኣዋርሕ" },
            { "type.ca.islamic", "ናይ ሂጅሪ ዓውደ ኣዋርሕ" },
            { "type.ca.iso8601", "ISO-8601 ዓውደ ኣዋርሕ" },
            { "type.ca.persian", "ናይ ፋርስ ዓውደ ኣዋርሕ" },
            { "type.cf.account", "ቅርጺ ባጤራ ሕሳብ" },
            { "type.nu.arabext", "ዝተዘርግሐ ኣሃዛት ዓረብ-ህንዳዊ" },
            { "type.nu.armnlow", "ኣርመንያ ንኣሽቱ ቁጽርታት" },
            { "type.nu.greklow", "ናይ ግሪኽ ንኣሽቱ ቁጽርታት" },
            { "type.nu.hanidec", "ቻይናዊ ዓስራይ ቁጽርታት" },
            { "type.nu.hansfin", "ዝተቐለለ ቻይናዊ ፋይናንሳዊ ቁጽርታት" },
            { "type.nu.hantfin", "ባህላዊ ቻይናዊ ፋይናንሳዊ ቁጽርታት" },
            { "type.nu.jpanfin", "ጃፓናዊ ፋይናንሳዊ ቁጽርታት" },
            { "type.nu.tamldec", "ናይ ታሚል አሃዛት" },
            { "type.ca.buddhist", "ናይ ቡድሃ ዓውደ ኣዋርሕ" },
            { "type.ca.ethiopic", "ናይ ግእዝ ዓውደ ኣዋርሕ" },
            { "type.ca.japanese", "ናይ ጃፓናዊ ዓውደ ኣዋርሕ" },
            { "type.cf.standard", "መደበኛ ቅርጺ ባጤራ" },
            { "type.co.standard", "መደበኛ ምድላው ስርዓት" },
            { "type.ms.uksystem", "ስርዓተ መለክዒ ሃጸያዊ" },
            { "type.ms.ussystem", "ስርዓት መለክዒ ኣሜሪካ" },
            { "type.nu.fullwide", "ምሉእ ስፍሓት ዘለዎም ኣሃዛት" },
            { "type.nu.romanlow", "ሮማዊ ንኣሽቱ ቁጽርታት" },
            { "type.ca.gregorian", "ጎርጎርዮሳዊ ዓውደ ኣዋርሕ" },
            { "ListKeyTypePattern", "{0}፦ {1}" },
            { "type.ca.islamic-tbla", "ናይ ሂጅሪ ዓውደ ኣዋርሕ (ሰንጠረዥ፣ ስነ-ፍልጠታዊ ዘመን)" },
            { "type.ca.islamic-civil", "ናይ ሂጅሪ ዓውደ ኣዋርሕ (ሰንጠረዥ፣ ሲቪላዊ ዘመን)" },
            { "ListCompositionPattern", "{0}፣ {1}" },
            { "type.ca.islamic-umalqura", "ናይ ሂጅሪ ዓውደ ኣዋርሕ (ኡም ኣል-ቁራ)" },
            { "type.ca.ethiopic-amete-alem", "ግእዝ ኣመተ ኣለም ዓውደ ኣዋርሕ" },
        };
        return data;
    }
}
