/*
 * Copyright (c) 2023, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package jdk.internal.event;

/**
 * A JFR event for serialization misdeclarations.
 * This event is mirrored in {@code jdk.jfr.events.SerializationMisdeclarationEvent}
 * where the metadata for the event is provided with annotations.
 * Some of the methods are replaced by generated methods when jfr is enabled.
 * Note that the order of the arguments of the {@link #commit(long,Class,String)}
 * method must be the same as the order of the fields.
 */
public class SerializationMisdeclarationEvent extends Event {

    public Class<?> misdeclaredClass;
    public String message;

    /**
     * Commit a serialization misdeclaration event.
     * The implementation of this method is generated automatically if jfr is enabled.
     * The order of the fields must be the same as the parameters in this method.
     * {@code commit(long,Class,String)}
     *
     * @param start             timestamp of the start of the operation
     * @param misdeclaredClass  the affected class
     * @param message           the specific event message
     */
    public static void commit(long start, Class<?> misdeclaredClass, String message) {
        // Generated by JFR
    }

    /**
     * Determine if an event should be emitted.  The duration of the operation
     * must exceed some threshold in order to commit the event.  The implementation
     * of this method is generated automatically if jfr is enabled.
     *
     * @param duration  time in nanoseconds to complete the operation
     * @return  true if the event should be commited
     */
    public static boolean shouldCommit(long duration) {
        // Generated by JFR
        return false;
    }

    /**
     * Determine if this kind of event is enabled.  The implementation
     * of this method is generated automatically if jfr is enabled.
     *
     * @return whether serialization misdeclaration events are enabled
     */
    public static boolean enabled() {
        // Generated by JFR
        return false;
    }

    /**
     * Fetch the current timestamp in nanoseconds.  This method is used
     * to determine the start and end of an operation.  The implementation
     * of this method is generated automatically if jfr is enabled.
     *
     * @return  the current timestamp value
     */
    public static long timestamp() {
        // Generated by JFR
        return 0L;
    }

}
